/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises;

import com.englishtown.promises.DeferredProgress;
import com.englishtown.promises.ProgressPromise;
import com.englishtown.promises.PromiseExt;
import com.englishtown.promises.PromiseState;
import com.englishtown.promises.Reducer;
import com.englishtown.promises.ResolveCallback;
import com.englishtown.promises.Resolver;
import com.englishtown.promises.Runnable;
import com.englishtown.promises.Runnable2;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.Value;
import com.englishtown.promises.ValueHolder;
import com.englishtown.promises.monitor.MonitorApi;
import com.englishtown.promises.monitor.PromiseStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class WhenProgress<TResolve, TProgress> {
    private List<Runnable<Void, Void>> handlerQueue = new ArrayList<Runnable<Void, Void>>();
    private static MonitorApi monitorApi = new MonitorApi();
    private static Executor nextTick = new Executor(){

        @Override
        public void execute(java.lang.Runnable command) {
            command.run();
        }
    };
    private final Runnable<ProgressPromise<TResolve, TProgress>, TResolve> identity = new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

        @Override
        public ProgressPromise<TResolve, TProgress> run(TResolve value) {
            return WhenProgress.this.resolve(value);
        }
    };

    public ProgressPromise<TResolve, TProgress> when(TResolve value) {
        return this.when(value, null);
    }

    public ProgressPromise<TResolve, TProgress> when(TResolve value, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled) {
        return this.when(this.resolve(value), onFulfilled);
    }

    public ProgressPromise<TResolve, TProgress> when(Thenable<TResolve, TProgress> promise) {
        return this.when(promise, null, null, null);
    }

    public ProgressPromise<TResolve, TProgress> when(Thenable<TResolve, TProgress> promise, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled) {
        return this.when(promise, onFulfilled, null, null);
    }

    public ProgressPromise<TResolve, TProgress> when(Thenable<TResolve, TProgress> promise, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected) {
        return this.when(promise, onFulfilled, onRejected, null);
    }

    public ProgressPromise<TResolve, TProgress> when(Thenable<TResolve, TProgress> promise, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
        return this.cast(promise).then(onFulfilled, onRejected, (Runnable)onProgress);
    }

    private Promise0 promise(ResolveCallback<TResolve, TProgress> resolver) {
        return this.createPromise0(resolver, monitorApi.promiseStatus());
    }

    protected Promise0 createPromise0(ResolveCallback<TResolve, TProgress> resolver, PromiseStatus status) {
        return new Promise0(resolver, status);
    }

    protected FulfilledPromise createFulfilledPromise(TResolve value) {
        return new FulfilledPromise(value);
    }

    protected RejectedPromise createRejectedPromise(Value<TResolve> value) {
        return new RejectedPromise(value);
    }

    protected ProgressingPromise createProgressingPromise(Value<TProgress> value) {
        return new ProgressingPromise(value);
    }

    private TrustedPromise cast(Thenable<TResolve, TProgress> x) {
        return TrustedPromise.class.isInstance(x) ? (TrustedPromise)x : this.resolve0((TResolve)x);
    }

    public ProgressPromise<TResolve, TProgress> resolve(Thenable<TResolve, TProgress> x) {
        return this.resolve0((TResolve)x);
    }

    private TrustedPromise resolve0(final Thenable<TResolve, TProgress> x) {
        return this.promise(new ResolveCallback<TResolve, TProgress>(){

            @Override
            public void run(Runnable<Void, Thenable<TResolve, TProgress>> resolve, Runnable<Void, Value<TResolve>> reject, Runnable<Void, Value<TProgress>> notify) {
                resolve.run(x);
            }
        });
    }

    public ProgressPromise<TResolve, TProgress> resolve(TResolve x) {
        return this.resolve0(x);
    }

    private TrustedPromise resolve0(final TResolve x) {
        return this.promise(new ResolveCallback<TResolve, TProgress>(){

            @Override
            public void run(Runnable<Void, Thenable<TResolve, TProgress>> resolve, Runnable<Void, Value<TResolve>> reject, Runnable<Void, Value<TProgress>> notify) {
                resolve.run(WhenProgress.this.createFulfilledPromise(x));
            }
        });
    }

    public ProgressPromise<TResolve, TProgress> reject(Thenable<TResolve, TProgress> x) {
        return this.when(x, new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(TResolve e) {
                return WhenProgress.this.createRejectedPromise(new Value(e));
            }
        });
    }

    public ProgressPromise<TResolve, TProgress> reject(Throwable x) {
        return this.createRejectedPromise(new Value(x));
    }

    public ProgressPromise<TResolve, TProgress> reject(Value<TResolve> x) {
        return this.createRejectedPromise(x);
    }

    public ProgressPromise<TResolve, TProgress> reject(TResolve x) {
        return this.createRejectedPromise(new Value<TResolve>(x));
    }

    public DeferredProgress<TResolve, TProgress> defer() {
        return this.defer0();
    }

    private InternalDeferred defer0() {
        final InternalDeferred deferred = new InternalDeferred();
        final ValueHolder pending = new ValueHolder();
        final ValueHolder<Boolean> resolved = new ValueHolder<Boolean>(false);
        ResolveCallback makeDeferred = new ResolveCallback<TResolve, TProgress>(){

            @Override
            public void run(final Runnable<Void, Thenable<TResolve, TProgress>> resolvePending, final Runnable<Void, Value<TResolve>> rejectPending, final Runnable<Void, Value<TProgress>> notifyPending) {
                deferred.resolver.resolve = new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                        if (((Boolean)resolved.value).booleanValue()) {
                            return WhenProgress.this.resolve(value);
                        }
                        resolved.value = true;
                        resolvePending.run(WhenProgress.this.resolve(value));
                        return (ProgressPromise)pending.value;
                    }
                };
                deferred.resolver.resolvePromise = new Runnable<ProgressPromise<TResolve, TProgress>, ProgressPromise<TResolve, TProgress>>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(ProgressPromise<TResolve, TProgress> value) {
                        if (((Boolean)resolved.value).booleanValue()) {
                            return WhenProgress.this.resolve(value);
                        }
                        resolved.value = true;
                        resolvePending.run(value);
                        return (ProgressPromise)pending.value;
                    }
                };
                deferred.resolver.reject = new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(Value<TResolve> reason) {
                        if (((Boolean)resolved.value).booleanValue()) {
                            return WhenProgress.this.resolve(WhenProgress.this.reject(reason));
                        }
                        resolved.value = true;
                        rejectPending.run(reason);
                        return (ProgressPromise)pending.value;
                    }
                };
                deferred.resolver.notify = new Runnable<Value<TProgress>, Value<TProgress>>(){

                    @Override
                    public Value<TProgress> run(Value<TProgress> update) {
                        notifyPending.run(update);
                        return update;
                    }
                };
            }
        };
        pending.value = this.promise(makeDeferred);
        deferred.promise = (TrustedPromise)pending.value;
        return deferred;
    }

    private <T> void runHandlers(List<Runnable<Void, T>> queue, T value) {
        for (int i = 0; i < queue.size(); ++i) {
            queue.get(i).run(value);
        }
    }

    private TrustedPromise coerce(Promise0 self, Thenable<TResolve, TProgress> x) {
        if (x == self) {
            return this.createRejectedPromise(new Value(new IllegalArgumentException()));
        }
        if (TrustedPromise.class.isInstance(x)) {
            return (TrustedPromise)x;
        }
        try {
            Thenable<TResolve, TProgress> untrustedThen = x;
            return untrustedThen != null ? this.assimilate(untrustedThen) : this.createFulfilledPromise(null);
        }
        catch (Throwable e) {
            return this.createRejectedPromise(new Value(e));
        }
    }

    private TrustedPromise assimilate(final Thenable<TResolve, TProgress> untrustedThen) {
        return this.promise(new ResolveCallback<TResolve, TProgress>(){

            @Override
            public void run(final Runnable<Void, Thenable<TResolve, TProgress>> resolve, final Runnable<Void, Value<TResolve>> reject, Runnable<Void, Value<TProgress>> notify) {
                WhenProgress.this.enqueue(new Runnable<Void, Void>(){

                    @Override
                    public Void run(Void aVoid) {
                        try {
                            untrustedThen.then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                                @Override
                                public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                                    resolve.run(WhenProgress.this.resolve(value));
                                    return null;
                                }
                            }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                                @Override
                                public ProgressPromise<TResolve, TProgress> run(Value<TResolve> value) {
                                    reject.run(value);
                                    return null;
                                }
                            }, null);
                        }
                        catch (Throwable e) {
                            reject.run(new Value(e));
                        }
                        return null;
                    }
                });
            }
        });
    }

    private void updateStatus(TrustedPromise value, final PromiseStatus status) {
        value.then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                status.fulfilled();
                return null;
            }
        }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(Value<TResolve> r) {
                status.rejected(r.getCause());
                return null;
            }
        });
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> some(List<? extends ProgressPromise<TResolve, TProgress>> promises, int howMany) {
        WhenProgress w1 = new WhenProgress();
        final ArrayList values = new ArrayList();
        if (promises == null || promises.isEmpty()) {
            return w1.resolve(values);
        }
        final InternalDeferred d1 = super.defer0();
        int len = promises.size();
        final ValueHolder<AtomicInteger> toResolve = new ValueHolder<AtomicInteger>(new AtomicInteger(Math.max(0, Math.min(howMany, len))));
        final ValueHolder<AtomicInteger> toReject = new ValueHolder<AtomicInteger>(new AtomicInteger(len - ((AtomicInteger)toResolve.value).get() + 1));
        final ArrayList reasons = new ArrayList();
        Runnable notify = d1.resolver.notify;
        final ValueHolder fulfillOne = new ValueHolder();
        final ValueHolder rejectOne = new ValueHolder();
        rejectOne.value = new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(Value<TResolve> reason) {
                reasons.add(reason.getValue());
                if (((AtomicInteger)toReject.value).decrementAndGet() == 0) {
                    rejectOne.value = null;
                    fulfillOne.value = null;
                    d1.getResolver().reject(new Value<List>(reasons, reason.getCause()));
                }
                return null;
            }
        };
        fulfillOne.value = new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                values.add(value);
                if (((AtomicInteger)toResolve.value).decrementAndGet() == 0) {
                    fulfillOne.value = null;
                    rejectOne.value = null;
                    d1.getResolver().resolve(values);
                }
                return null;
            }
        };
        Runnable rejecter = new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(Value<TResolve> value) {
                return rejectOne.value != null ? (ProgressPromise)((Runnable)rejectOne.value).run(value) : null;
            }
        };
        Runnable fulfiller = new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                return fulfillOne.value != null ? (ProgressPromise)((Runnable)fulfillOne.value).run(value) : null;
            }
        };
        for (int i = 0; i < len; ++i) {
            if (i >= promises.size()) continue;
            this.when(promises.get(i), fulfiller, rejecter, notify);
        }
        return d1.getPromise();
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> someValues(List<TResolve> values, int howMany) {
        return this.some(this.resolveValues(values), howMany);
    }

    public ProgressPromise<TResolve, TProgress> any(List<? extends ProgressPromise<TResolve, TProgress>> promises) {
        final DeferredProgress<TResolve, TProgress> d = this.defer();
        this.some(promises, 1).then(new Runnable<ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>>(){

            @Override
            public ProgressPromise<List<? extends TResolve>, TProgress> run(List<? extends TResolve> value) {
                Object val = null;
                if (value.size() > 0) {
                    val = value.get(0);
                }
                d.getResolver().resolve(val);
                return null;
            }
        }, new Runnable<ProgressPromise<List<? extends TResolve>, TProgress>, Value<List<? extends TResolve>>>(){

            @Override
            public ProgressPromise<List<? extends TResolve>, TProgress> run(Value<List<? extends TResolve>> value) {
                d.getResolver().reject(value.getCause());
                return null;
            }
        }, new Runnable<Value<TProgress>, Value<TProgress>>(){

            @Override
            public Value<TProgress> run(Value<TProgress> value) {
                d.getResolver().notify(value);
                return null;
            }
        });
        return d.getPromise();
    }

    public ProgressPromise<TResolve, TProgress> anyValues(List<TResolve> values) {
        return this.any(this.resolveValues(values));
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> all(List<? extends ProgressPromise<TResolve, TProgress>> promises) {
        return this._map(promises, this.identity, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> allValues(List<TResolve> values) {
        return this.all(this.resolveValues(values));
    }

    @SafeVarargs
    public final ProgressPromise<List<? extends TResolve>, TProgress> join(ProgressPromise<TResolve, TProgress> ... promises) {
        List<Object> input = promises == null ? new ArrayList() : Arrays.asList(promises);
        return this._map(input, this.identity, null);
    }

    @SafeVarargs
    public final ProgressPromise<List<? extends TResolve>, TProgress> join(TResolve ... values) {
        List<Object> input = values == null ? new ArrayList() : Arrays.asList(values);
        return this._map(this.resolveValues(input), this.identity, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> map(List<? extends ProgressPromise<TResolve, TProgress>> promises, Runnable<ProgressPromise<TResolve, TProgress>, TResolve> mapFunc) {
        return this._map(promises, mapFunc, null);
    }

    public ProgressPromise<List<? extends TResolve>, TProgress> map(ProgressPromise<List<? extends TResolve>, TProgress> promise, final Runnable<ProgressPromise<TResolve, TProgress>, TResolve> mapFunc) {
        WhenProgress<List<? extends TResolve>, TProgress> when = new WhenProgress<List<? extends TResolve>, TProgress>();
        return when.when(promise, new Runnable<ProgressPromise<List<? extends TResolve>, TProgress>, List<? extends TResolve>>(){

            @Override
            public ProgressPromise<List<? extends TResolve>, TProgress> run(List<? extends TResolve> values) {
                return WhenProgress.this._map(WhenProgress.this.resolveValues(values), mapFunc, null);
            }
        });
    }

    private ProgressPromise<List<? extends TResolve>, TProgress> _map(List<? extends ProgressPromise<TResolve, TProgress>> promises, final Runnable<ProgressPromise<TResolve, TProgress>, TResolve> mapFunc, final Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>> fallback) {
        WhenProgress<Serializable, TProgress> w = new WhenProgress<Serializable, TProgress>();
        if (promises == null) {
            return w.reject((Serializable)new RuntimeException("promises were null"));
        }
        if (promises.isEmpty()) {
            return w.resolve(new ArrayList());
        }
        int len = promises.size();
        final ValueHolder<AtomicInteger> toResolve = new ValueHolder<AtomicInteger>(new AtomicInteger(len));
        final DeferredProgress<TResolve, TProgress> d = w.defer();
        final ArrayList<Object> results = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            results.add(null);
        }
        Runnable2 resolveOne = new Runnable2<Void, ProgressPromise<TResolve, TProgress>, Integer>(){

            @Override
            public Void run(ProgressPromise<TResolve, TProgress> item, final Integer index) {
                WhenProgress.this.when(item, mapFunc, fallback).then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(TResolve mapped) {
                        results.set(index, mapped);
                        if (((AtomicInteger)toResolve.value).decrementAndGet() == 0) {
                            d.getResolver().resolve(results);
                        }
                        return null;
                    }
                }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(Value<TResolve> value) {
                        d.getResolver().reject(new Value<List<Object>>(Arrays.asList(value.getValue()), value.getCause()));
                        return null;
                    }
                }, new Runnable<Value<TProgress>, Value<TProgress>>(){

                    @Override
                    public Value<TProgress> run(Value<TProgress> update) {
                        d.getResolver().notify(update);
                        return null;
                    }
                });
                return null;
            }
        };
        for (int i = 0; i < len; ++i) {
            resolveOne.run(promises.get(i), i);
        }
        return d.getPromise();
    }

    public <T> ProgressPromise<T, TProgress> reduce(List<ProgressPromise<TResolve, TProgress>> promises, Reducer<T, TResolve> reduceFunc) {
        return this.reduce0(promises, reduceFunc, null);
    }

    public <T> ProgressPromise<T, TProgress> reduce(List<ProgressPromise<TResolve, TProgress>> promises, Reducer<T, TResolve> reduceFunc, T initialValue) {
        WhenProgress<T, TProgress> when = new WhenProgress<T, TProgress>();
        return this.reduce(promises, reduceFunc, when.resolve(initialValue));
    }

    public <T> ProgressPromise<T, TProgress> reduce(List<ProgressPromise<TResolve, TProgress>> promises, Reducer<T, TResolve> reduceFunc, ProgressPromise<T, TProgress> initialValue) {
        return this.reduce0(promises, reduceFunc, new Value<ProgressPromise<T, TProgress>>(initialValue));
    }

    public <T> ProgressPromise<T, TProgress> reduce(ProgressPromise<List<TResolve>, TProgress> promise, Reducer<T, TResolve> reduceFunc, T initialValue) {
        WhenProgress<T, TProgress> when = new WhenProgress<T, TProgress>();
        return this.reduce(promise, reduceFunc, when.resolve(initialValue));
    }

    public <T> ProgressPromise<T, TProgress> reduce(ProgressPromise<List<TResolve>, TProgress> promise, final Reducer<T, TResolve> reduceFunc, final ProgressPromise<T, TProgress> initialValue) {
        final DeferredProgress<TResolve, TProgress> d1 = new WhenProgress<TResolve, TProgress>().defer();
        WhenProgress<List<TResolve>, TProgress> w2 = new WhenProgress<List<TResolve>, TProgress>();
        w2.when(promise, new Runnable<ProgressPromise<List<TResolve>, TProgress>, List<TResolve>>(){

            @Override
            public ProgressPromise<List<TResolve>, TProgress> run(List<TResolve> values) {
                d1.getResolver().resolve(WhenProgress.this.reduce(WhenProgress.this.resolveValues(values), reduceFunc, initialValue));
                return null;
            }
        }, new Runnable<ProgressPromise<List<TResolve>, TProgress>, Value<List<TResolve>>>(){

            @Override
            public ProgressPromise<List<TResolve>, TProgress> run(Value<List<TResolve>> value) {
                d1.getResolver().reject(value.getCause());
                return null;
            }
        });
        return d1.getPromise();
    }

    public <T> ProgressPromise<T, TProgress> reduceValues(List<TResolve> values, Reducer<T, TResolve> reduceFunc) {
        return this.reduce0(this.resolveValues(values), reduceFunc, null);
    }

    public <T> ProgressPromise<T, TProgress> reduceValues(List<TResolve> values, Reducer<T, TResolve> reduceFunc, T initialValue) {
        WhenProgress<T, TProgress> when = new WhenProgress<T, TProgress>();
        return this.reduceValues(values, reduceFunc, when.resolve(initialValue));
    }

    public <T> ProgressPromise<T, TProgress> reduceValues(List<TResolve> values, Reducer<T, TResolve> reduceFunc, ProgressPromise<T, TProgress> initialValue) {
        return this.reduce0(this.resolveValues(values), reduceFunc, new Value<ProgressPromise<T, TProgress>>(initialValue));
    }

    private <T> ProgressPromise<T, TProgress> reduce0(List<ProgressPromise<TResolve, TProgress>> promises, final Reducer<T, TResolve> reduceFunc, Value<ProgressPromise<T, TProgress>> initialValue) {
        final WhenProgress<Object, TProgress> w = new WhenProgress<Object, TProgress>();
        if (promises == null) {
            return w.reject((Object)null);
        }
        final DeferredProgress<TResolve, TProgress> d1 = w.defer();
        Reducer reducerWrapper = new Reducer<ProgressPromise<T, TProgress>, ProgressPromise<TResolve, TProgress>>(){

            @Override
            public ProgressPromise<T, TProgress> run(ProgressPromise<T, TProgress> current, final ProgressPromise<TResolve, TProgress> val, final int i, final int total) {
                final DeferredProgress d2 = w.defer();
                return w.when(current, new Runnable<ProgressPromise<T, TProgress>, T>(){

                    @Override
                    public ProgressPromise<T, TProgress> run(final T c) {
                        WhenProgress.this.when(val, new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                            @Override
                            public ProgressPromise<TResolve, TProgress> run(TResolve v) {
                                final Object value = reduceFunc.run(c, v, i, total);
                                if (value instanceof ProgressPromise) {
                                    WhenProgress<Object, Object> w = new WhenProgress<Object, Object>();
                                    w.when((ProgressPromise)value, new Runnable<ProgressPromise<Object, Object>, Object>(){

                                        @Override
                                        public ProgressPromise<Object, Object> run(Object obj) {
                                            d2.getResolver().resolve(value);
                                            return null;
                                        }
                                    });
                                } else {
                                    d2.getResolver().resolve(value);
                                }
                                return null;
                            }
                        }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                            @Override
                            public ProgressPromise<TResolve, TProgress> run(Value<TResolve> v) {
                                final Object value = reduceFunc.run(c, v.getValue(), i, total);
                                if (value instanceof ProgressPromise) {
                                    WhenProgress<Object, Object> w = new WhenProgress<Object, Object>();
                                    w.when((ProgressPromise)value, new Runnable<ProgressPromise<Object, Object>, Object>(){

                                        @Override
                                        public ProgressPromise<Object, Object> run(Object obj) {
                                            d2.getResolver().reject(value);
                                            return null;
                                        }
                                    });
                                } else {
                                    d2.getResolver().reject(value);
                                }
                                return null;
                            }
                        });
                        return d2.getPromise();
                    }
                });
            }
        };
        try {
            WhenProgress.reduceList(promises, reducerWrapper, initialValue).then(new Runnable<ProgressPromise<T, TProgress>, T>(){

                @Override
                public ProgressPromise<T, TProgress> run(T value) {
                    d1.getResolver().resolve(value);
                    return null;
                }
            }, new Runnable<ProgressPromise<T, TProgress>, Value<T>>(){

                @Override
                public ProgressPromise<T, TProgress> run(Value<T> value) {
                    d1.getResolver().reject(value);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            d1.getResolver().reject(t);
        }
        return d1.getPromise();
    }

    private static <T1, T2> T1 reduceList(List<T2> list, Reducer<T1, T2> reduceFunc, Value<T1> initialValue) {
        Object reduced;
        int len;
        int i = 0;
        int n = len = list == null ? 0 : list.size();
        if (initialValue == null) {
            if (i >= len) {
                throw new RuntimeException("No values to reduce.");
            }
            reduced = list.get(i++);
        } else {
            reduced = initialValue.getValue();
        }
        while (i < len) {
            reduced = reduceFunc.run(reduced, list.get(i), i, len);
            ++i;
        }
        return reduced;
    }

    public ProgressPromise<TResolve, TProgress> chain(ProgressPromise<TResolve, TProgress> promise, Resolver<TResolve, TProgress> resolver) {
        return this.chain0(promise, resolver, null);
    }

    public ProgressPromise<TResolve, TProgress> chain(ProgressPromise<TResolve, TProgress> promise, Resolver<TResolve, TProgress> resolver, TResolve resolveValue) {
        return this.chain0(promise, resolver, new Value<TResolve>(resolveValue));
    }

    private ProgressPromise<TResolve, TProgress> chain0(ProgressPromise<TResolve, TProgress> promise, final Resolver<TResolve, TProgress> resolver, final Value<TResolve> resolveValue) {
        return this.when(promise, new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(TResolve val) {
                val = resolveValue != null ? resolveValue.getValue() : val;
                resolver.resolve(val);
                return WhenProgress.this.resolve(val);
            }
        }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

            @Override
            public ProgressPromise<TResolve, TProgress> run(Value<TResolve> reason) {
                resolver.reject(reason);
                return WhenProgress.this.reject(reason);
            }
        }, new Runnable<Value<TProgress>, Value<TProgress>>(){

            @Override
            public Value<TProgress> run(Value<TProgress> value) {
                resolver.notify(value);
                return value;
            }
        });
    }

    public ProgressPromise<List<TResolve>, TProgress> sequence(List<Runnable<ProgressPromise<TResolve, TProgress>, Void>> tasks) {
        return this.sequence(tasks, null);
    }

    public <TArg> ProgressPromise<List<TResolve>, TProgress> sequence(List<Runnable<ProgressPromise<TResolve, TProgress>, TArg>> tasks, final TArg arg) {
        WhenProgress<Runnable<ProgressPromise<TResolve, TProgress>, TArg>, TProgress> w1 = new WhenProgress<Runnable<ProgressPromise<TResolve, TProgress>, TArg>, TProgress>();
        final WhenProgress w2 = new WhenProgress();
        final DeferredProgress<TResolve, TProgress> d1 = w2.defer();
        ProgressPromise list = w2.resolve(new ArrayList());
        w1.reduceValues(tasks, (Reducer)new Reducer<ProgressPromise<List<TResolve>, TProgress>, Runnable<ProgressPromise<TResolve, TProgress>, TArg>>(){

            @Override
            public ProgressPromise<List<TResolve>, TProgress> run(final ProgressPromise<List<TResolve>, TProgress> results, Runnable<ProgressPromise<TResolve, TProgress>, TArg> task, int currentIndex, int total) {
                ProgressPromise taskResult;
                final DeferredProgress d2 = w2.defer();
                try {
                    taskResult = task.run(arg);
                }
                catch (RuntimeException ex) {
                    taskResult = WhenProgress.this.reject(ex);
                }
                WhenProgress.this.when(taskResult, new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(final TResolve value) {
                        w2.when(results, new Runnable<ProgressPromise<List<TResolve>, TProgress>, List<TResolve>>(){

                            @Override
                            public ProgressPromise<List<TResolve>, TProgress> run(List<TResolve> results) {
                                results.add(value);
                                d2.getResolver().resolve(results);
                                return null;
                            }
                        });
                        return null;
                    }
                }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(Value<TResolve> value) {
                        d1.getResolver().reject(new Value<List<Object>>(Arrays.asList(value.getValue()), value.getCause()));
                        return null;
                    }
                });
                return d2.getPromise();
            }
        }, (Object)list).then(new Runnable<ProgressPromise<ProgressPromise<List<TResolve>, TProgress>, TProgress>, ProgressPromise<List<TResolve>, TProgress>>(){

            @Override
            public ProgressPromise<ProgressPromise<List<TResolve>, TProgress>, TProgress> run(ProgressPromise<List<TResolve>, TProgress> value) {
                w2.when(value, new Runnable<ProgressPromise<List<TResolve>, TProgress>, List<TResolve>>(){

                    @Override
                    public ProgressPromise<List<TResolve>, TProgress> run(List<TResolve> value) {
                        d1.getResolver().resolve(value);
                        return null;
                    }
                });
                return null;
            }
        });
        return d1.getPromise();
    }

    private PromiseState<TResolve> toFulfilledState(TResolve x) {
        return new PromiseState().setState(PromiseState.State.FULFILLED).setValue(x);
    }

    private PromiseState<TResolve> toRejectedState(Value<TResolve> x) {
        return new PromiseState().setState(PromiseState.State.REJECTED).setValue(x.getValue()).setReason(x.getCause());
    }

    private PromiseState<TResolve> toPendingState() {
        return new PromiseState().setState(PromiseState.State.PENDING);
    }

    private void enqueue(Runnable<Void, Void> task) {
        this.handlerQueue.add(task);
        if (this.handlerQueue.size() == 1) {
            nextTick.execute(new java.lang.Runnable(){

                @Override
                public void run() {
                    WhenProgress.this.drainQueue();
                }
            });
        }
    }

    private void drainQueue() {
        List q = this.handlerQueue;
        this.handlerQueue = new ArrayList<Runnable<Void, Void>>();
        this.runHandlers(q, null);
    }

    protected static MonitorApi getMonitorApi() {
        return monitorApi;
    }

    public static void setNextTick(Executor executor) {
        nextTick = executor;
    }

    public List<ProgressPromise<TResolve, TProgress>> resolveValues(List<? extends TResolve> values) {
        if (values == null) {
            return null;
        }
        ArrayList<ProgressPromise<TResolve, TProgress>> promises = new ArrayList<ProgressPromise<TResolve, TProgress>>();
        for (TResolve value : values) {
            promises.add(value != null ? this.resolve(value) : null);
        }
        return promises;
    }

    private void crash(Throwable fatalError) {
        monitorApi.reportUnhandled();
        throw new RuntimeException(fatalError);
    }

    protected class ProgressingPromise
    extends TrustedPromise {
        private Value<TProgress> value;

        protected ProgressingPromise(Value<TProgress> value) {
            this.value = value;
        }

        @Override
        protected void _when(Runnable<Void, Thenable<TResolve, TProgress>> resolve, Runnable<Void, Value<TProgress>> notify, Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
            try {
                notify.run(onProgress != null ? onProgress.run(this.value) : this.value);
            }
            catch (Throwable e) {
                notify.run(new Value(e));
            }
        }

        @Override
        public PromiseState<TResolve> inspect() {
            return WhenProgress.this.toPendingState();
        }
    }

    protected class RejectedPromise
    extends TrustedPromise {
        private Value<TResolve> value;

        protected RejectedPromise(Value<TResolve> reason) {
            this.value = reason;
        }

        @Override
        protected void _when(Runnable<Void, Thenable<TResolve, TProgress>> resolve, Runnable<Void, Value<TProgress>> notify, Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
            try {
                resolve.run(onRejected != null ? onRejected.run(this.value) : this);
            }
            catch (Throwable e) {
                resolve.run(WhenProgress.this.createRejectedPromise(new Value(e)));
            }
        }

        @Override
        public PromiseState<TResolve> inspect() {
            return WhenProgress.this.toRejectedState(this.value);
        }
    }

    protected class FulfilledPromise
    extends TrustedPromise {
        private TResolve value;

        protected FulfilledPromise(TResolve value) {
            this.value = value;
        }

        @Override
        public PromiseState<TResolve> inspect() {
            return WhenProgress.this.toFulfilledState(this.value);
        }

        @Override
        protected void _when(Runnable<Void, Thenable<TResolve, TProgress>> resolve, Runnable<Void, Value<TProgress>> notify, Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
            try {
                resolve.run(onFulfilled != null ? onFulfilled.run(this.value) : WhenProgress.this.resolve(this.value));
            }
            catch (Throwable e) {
                resolve.run(WhenProgress.this.createRejectedPromise(new Value(e)));
            }
        }
    }

    private class InternalResolver
    implements Resolver<TResolve, TProgress> {
        private Runnable<ProgressPromise<TResolve, TProgress>, TResolve> resolve;
        private Runnable<ProgressPromise<TResolve, TProgress>, ProgressPromise<TResolve, TProgress>> resolvePromise;
        private Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>> reject;
        private Runnable<Value<TProgress>, Value<TProgress>> notify;

        private InternalResolver() {
        }

        @Override
        public ProgressPromise<TResolve, TProgress> resolve(TResolve value) {
            return this.resolve.run(value);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> resolve(ProgressPromise<TResolve, TProgress> value) {
            return this.resolvePromise.run(value);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> reject(TResolve reason) {
            return this.reject(new Value(reason));
        }

        @Override
        public ProgressPromise<TResolve, TProgress> reject(Throwable reason) {
            return this.reject(new Value(reason));
        }

        @Override
        public ProgressPromise<TResolve, TProgress> reject(Value<TResolve> reason) {
            return this.reject.run(reason);
        }

        @Override
        public Value<TProgress> notify(TProgress update) {
            return this.notify(new Value(update));
        }

        @Override
        public Value<TProgress> notify(Value<TProgress> update) {
            return this.notify.run(update);
        }
    }

    private class InternalDeferred
    implements DeferredProgress<TResolve, TProgress> {
        private final InternalResolver resolver;
        private TrustedPromise promise;

        InternalDeferred() {
            this.resolver = new InternalResolver();
        }

        @Override
        public Resolver<TResolve, TProgress> getResolver() {
            return this.resolver;
        }

        @Override
        public ProgressPromise<TResolve, TProgress> getPromise() {
            return this.promise;
        }
    }

    protected abstract class TrustedPromise
    implements PromiseExt<TResolve, TProgress> {
        protected PromiseStatus _status;

        protected TrustedPromise() {
        }

        protected abstract void _when(Runnable<Void, Thenable<TResolve, TProgress>> var1, Runnable<Void, Value<TProgress>> var2, Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> var3, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> var4, Runnable<Value<TProgress>, Value<TProgress>> var5);

        @Override
        public abstract PromiseState<TResolve> inspect();

        public TrustedPromise then(final Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, final Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, final Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
            final TrustedPromise self = this;
            return WhenProgress.this.createPromise0(new ResolveCallback<TResolve, TProgress>(){

                @Override
                public void run(Runnable<Void, Thenable<TResolve, TProgress>> resolve, Runnable<Void, Value<TResolve>> reject, Runnable<Void, Value<TProgress>> notify) {
                    self._when(resolve, notify, onFulfilled, onRejected, onProgress);
                }
            }, this._status == null ? null : this._status.observed());
        }

        public TrustedPromise then(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected) {
            return this.then(onFulfilled, onRejected, (Runnable)null);
        }

        public TrustedPromise then(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled) {
            return this.then(onFulfilled, (Runnable)null, (Runnable)null);
        }

        public TrustedPromise otherwise(Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected) {
            return this.then((Runnable)null, onRejected, (Runnable)null);
        }

        private TrustedPromise catch0(Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected) {
            return this.otherwise(onRejected);
        }

        public TrustedPromise ensure(final Runnable<? extends ProgressPromise<TResolve, TProgress>, Void> onFulfilledOrRejected) {
            if (onFulfilledOrRejected != null) {
                return ((TrustedPromise)this.then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(TResolve value) {
                        return WhenProgress.this.resolve((Thenable)onFulfilledOrRejected.run(null));
                    }
                }, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                    @Override
                    public ProgressPromise<TResolve, TProgress> run(Value<TResolve> value) {
                        return WhenProgress.this.resolve((Thenable)onFulfilledOrRejected.run(null));
                    }
                })).yield((Thenable)this);
            }
            return this;
        }

        public TrustedPromise done(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> handleResult, Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> handleError) {
            return super.catch0(new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                @Override
                public ProgressPromise<TResolve, TProgress> run(Value<TResolve> value) {
                    WhenProgress.this.crash(value.getCause());
                    return null;
                }
            });
        }

        @Override
        public ProgressPromise<TResolve, TProgress> yield(final TResolve value) {
            return this.then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                @Override
                public ProgressPromise<TResolve, TProgress> run(TResolve _) {
                    return WhenProgress.this.resolve(value);
                }
            });
        }

        public TrustedPromise yield(final Thenable<TResolve, TProgress> value) {
            return this.then(new Runnable<ProgressPromise<TResolve, TProgress>, TResolve>(){

                @Override
                public ProgressPromise<TResolve, TProgress> run(TResolve _) {
                    return WhenProgress.this.resolve(value);
                }
            });
        }

        public TrustedPromise tap(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilledSideEffect) {
            return ((TrustedPromise)this.then(onFulfilledSideEffect)).yield((Thenable)this);
        }

        @Override
        public ProgressPromise<TResolve, TProgress> always(Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilledOrRejected) {
            return this.always(onFulfilledOrRejected, (Runnable)null);
        }

        public TrustedPromise always(final Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilledOrRejected, Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
            return this.then(onFulfilledOrRejected, new Runnable<ProgressPromise<TResolve, TProgress>, Value<TResolve>>(){

                @Override
                public ProgressPromise<TResolve, TProgress> run(Value<TResolve> reason) {
                    return (ProgressPromise)onFulfilledOrRejected.run(reason.getValue());
                }
            }, onProgress);
        }
    }

    protected class Promise0
    extends TrustedPromise {
        private ValueHolder<TrustedPromise> value = new ValueHolder();
        private ValueHolder<List<Runnable<Void, TrustedPromise>>> consumers = new ValueHolder();

        protected Promise0(ResolveCallback<TResolve, TProgress> resolver, final PromiseStatus status) {
            final Promise0 self = this;
            this._status = status;
            this.consumers.value = new ArrayList();
            final Runnable promiseResolve = new Runnable<Void, Thenable<TResolve, TProgress>>(){

                @Override
                public Void run(Thenable<TResolve, TProgress> val) {
                    if (((Promise0)Promise0.this).consumers.value == null) {
                        return null;
                    }
                    final List queue = (List)((Promise0)Promise0.this).consumers.value;
                    ((Promise0)Promise0.this).consumers.value = null;
                    ((Promise0)Promise0.this).value.value = WhenProgress.this.coerce(self, val);
                    WhenProgress.this.enqueue(new Runnable<Void, Void>(){

                        @Override
                        public Void run(Void aVoid) {
                            if (status != null) {
                                WhenProgress.this.updateStatus((TrustedPromise)((Promise0)Promise0.this).value.value, status);
                            }
                            WhenProgress.this.runHandlers(queue, ((Promise0)Promise0.this).value.value);
                            return null;
                        }
                    });
                    return null;
                }
            };
            Runnable promiseReject = new Runnable<Void, Value<TResolve>>(){

                @Override
                public Void run(Value<TResolve> reason) {
                    promiseResolve.run(WhenProgress.this.createRejectedPromise(reason));
                    return null;
                }
            };
            Runnable promiseNotify = new Runnable<Void, Value<TProgress>>(){

                @Override
                public Void run(final Value<TProgress> update) {
                    final List queue = (List)((Promise0)Promise0.this).consumers.value;
                    if (queue != null) {
                        WhenProgress.this.enqueue(new Runnable<Void, Void>(){

                            @Override
                            public Void run(Void aVoid) {
                                WhenProgress.this.runHandlers(queue, WhenProgress.this.createProgressingPromise(update));
                                return null;
                            }
                        });
                    }
                    return null;
                }
            };
            try {
                resolver.run(promiseResolve, promiseReject, promiseNotify);
            }
            catch (Throwable e) {
                promiseReject.run(new Value(e));
            }
        }

        @Override
        public PromiseState<TResolve> inspect() {
            return this.value.value != null ? ((TrustedPromise)this.value.value).inspect() : WhenProgress.this.toPendingState();
        }

        @Override
        protected void _when(final Runnable<Void, Thenable<TResolve, TProgress>> resolve, final Runnable<Void, Value<TProgress>> notify, final Runnable<? extends ProgressPromise<TResolve, TProgress>, TResolve> onFulfilled, final Runnable<? extends ProgressPromise<TResolve, TProgress>, Value<TResolve>> onRejected, final Runnable<Value<TProgress>, Value<TProgress>> onProgress) {
            final Runnable<Void, TrustedPromise> deliver = new Runnable<Void, TrustedPromise>(){

                @Override
                public Void run(TrustedPromise p) {
                    p._when(resolve, notify, onFulfilled, onRejected, onProgress);
                    return null;
                }
            };
            if (this.consumers.value != null) {
                ((List)this.consumers.value).add(deliver);
            } else {
                WhenProgress.this.enqueue(new Runnable<Void, Void>(){

                    @Override
                    public Void run(Void aVoid) {
                        deliver.run(((Promise0)Promise0.this).value.value);
                        return null;
                    }
                });
            }
        }
    }
}

