/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.monitor.impl;

import com.englishtown.promises.monitor.Aggregator;
import com.englishtown.promises.monitor.PromiseStatus;
import com.englishtown.promises.monitor.Reporter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultAggregator
implements Aggregator {
    private final Reporter reporter;
    private Map<Long, PromiseStatus> promises;
    private AtomicLong nextKey;

    public DefaultAggregator(Reporter reporter) {
        this.reporter = reporter;
        this.reset();
    }

    @Override
    public PromiseStatus promiseStatus() {
        return new PromiseStatusImpl(this);
    }

    @Override
    public void report() {
        this.reporter.report(this.promises);
    }

    @Override
    public void reset() {
        this.nextKey = new AtomicLong();
        this.promises = new HashMap<Long, PromiseStatus>();
    }

    private class PromiseStatusImpl
    implements PromiseStatus {
        private long key;
        private long timestamp;
        private Aggregator parent;
        private Throwable createdAt;
        private Throwable reason;
        private Throwable rejectedAt;

        public PromiseStatusImpl(Aggregator parent) {
            try {
                throw new Error();
            }
            catch (Error e) {
                Error stackHolder = e;
                this.key = DefaultAggregator.this.nextKey.incrementAndGet();
                DefaultAggregator.this.promises.put(this.key, this);
                this.parent = parent;
                this.timestamp = System.currentTimeMillis();
                this.createdAt = stackHolder;
                return;
            }
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public Throwable getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public Throwable getReason() {
            return this.reason;
        }

        @Override
        public Throwable getRejectedAt() {
            return this.rejectedAt;
        }

        @Override
        public PromiseStatus observed() {
            PromiseStatus status = (PromiseStatus)DefaultAggregator.this.promises.remove(this.key);
            if (status != null) {
                DefaultAggregator.this.report();
            }
            return new PromiseStatusImpl(this.parent);
        }

        @Override
        public void fulfilled() {
            PromiseStatus status = (PromiseStatus)DefaultAggregator.this.promises.remove(this.key);
            if (status != null) {
                DefaultAggregator.this.report();
            }
        }

        @Override
        public void rejected(Throwable reason) {
            PromiseStatus status = (PromiseStatus)DefaultAggregator.this.promises.remove(this.key);
            if (status != null) {
                try {
                    throw new Error(reason);
                }
                catch (Throwable e) {
                    Throwable stackHolder = e;
                    this.reason = reason;
                    this.rejectedAt = stackHolder;
                    DefaultAggregator.this.report();
                }
            }
        }
    }
}

