/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.impl;

import com.englishtown.promises.Environment;
import com.englishtown.promises.Reporter;
import com.englishtown.promises.internal.handlers.RejectedHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class AbstractReporter
implements Reporter {
    private Queue<Runnable> tasks = new ConcurrentLinkedQueue<Runnable>();
    private List<RejectedHandler<?>> reported = new ArrayList();
    private boolean running = false;
    private final Environment environment;

    protected AbstractReporter(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void onPotentiallyUnhandledRejection(RejectedHandler<?> rejection, Object context) {
        this.enqueue(() -> this.report(rejection));
    }

    @Override
    public void onPotentiallyUnhandledRejectionHandled(RejectedHandler<?> rejection) {
        this.enqueue(() -> this.unreport(rejection));
    }

    @Override
    public void onFatalRejection(RejectedHandler<?> rejection, Object context) {
        this.enqueue(() -> this.throwit(rejection.getValue()));
    }

    protected abstract void logError(RejectedHandler<?> var1);

    protected abstract void logInfo(RejectedHandler<?> var1);

    private void report(RejectedHandler<?> r) {
        if (!r.handled()) {
            this.reported.add(r);
            this.logError(r);
        }
    }

    private void unreport(RejectedHandler<?> r) {
        if (this.reported.remove(r)) {
            this.logInfo(r);
        }
    }

    private void enqueue(Runnable f) {
        this.tasks.add(f);
        if (!this.running) {
            this.running = true;
            this.environment.getScheduler().enqueue(this::flush);
        }
    }

    private void flush() {
        this.running = false;
        Runnable task = this.tasks.poll();
        while (task != null) {
            task.run();
            task = this.tasks.poll();
        }
    }

    private void throwit(Throwable e) {
        RuntimeException re = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        throw re;
    }
}

