/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.impl;

import com.englishtown.promises.Scheduler;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Provider;

public class DefaultScheduler
implements Scheduler {
    private final Executor _enqueue;
    private final Queue<Runnable> _handlerQueue;
    private final Queue<Runnable> _afterQueue;
    private boolean _running;

    @Inject
    public DefaultScheduler(Provider<Executor> enqueue) {
        this._enqueue = (Executor)enqueue.get();
        this._handlerQueue = new ConcurrentLinkedQueue<Runnable>();
        this._afterQueue = new ConcurrentLinkedQueue<Runnable>();
        this._running = false;
    }

    @Override
    public void enqueue(Runnable task) {
        this._handlerQueue.add(task);
        if (!this._running) {
            this._running = true;
            this._enqueue.execute(this::drain);
        }
    }

    @Override
    public void afterQueue(Runnable task) {
        this._afterQueue.add(task);
        if (!this._running) {
            this._running = true;
            this._enqueue.execute(this::drain);
        }
    }

    public void drain() {
        Queue<Runnable> q = this._handlerQueue;
        Runnable task = q.poll();
        while (task != null) {
            task.run();
            task = q.poll();
        }
        this._running = false;
        q = this._afterQueue;
        task = q.poll();
        while (task != null) {
            task.run();
            task = q.poll();
        }
    }
}

