/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.impl;

import com.englishtown.promises.Deferred;
import com.englishtown.promises.Promise;
import com.englishtown.promises.PromiseResolver;
import com.englishtown.promises.Resolver;
import com.englishtown.promises.State;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.When;
import com.englishtown.promises.internal.ArrayHelper;
import com.englishtown.promises.internal.PromiseHelper;
import com.englishtown.promises.internal.TrustedPromise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;

public class DefaultWhen
implements When {
    private final PromiseHelper helper;
    private final ArrayHelper arrayHelper;

    @Inject
    public DefaultWhen(PromiseHelper helper, ArrayHelper arrayHelper) {
        this.helper = helper;
        this.arrayHelper = arrayHelper;
    }

    @Override
    public <T> Promise<T> when(T x) {
        return this.when(x, null, null);
    }

    @Override
    public <T> Promise<T> when(Thenable<T> x) {
        return this.when(x, (Function)null, (Function)null);
    }

    @Override
    public <T, U> Promise<U> when(T x, Function<T, ? extends Thenable<U>> onFulfilled) {
        return this.when(x, onFulfilled, null);
    }

    @Override
    public <T, U> Promise<U> when(T x, Function<T, ? extends Thenable<U>> onFulfilled, Function<Throwable, ? extends Thenable<U>> onRejected) {
        Promise<T> p = this.resolve(x);
        return p.then(onFulfilled, onRejected);
    }

    @Override
    public <T, U> Promise<U> when(Thenable<T> x, Function<T, ? extends Thenable<U>> onFulfilled) {
        return this.when(x, onFulfilled, (Function<Throwable, ? extends Thenable<U>>)null);
    }

    @Override
    public <T, U> Promise<U> when(Thenable<T> x, Function<T, ? extends Thenable<U>> onFulfilled, Function<Throwable, ? extends Thenable<U>> onRejected) {
        Promise<T> p = this.resolve(x);
        return p.then(onFulfilled, onRejected);
    }

    @Override
    public <T> Promise<T> resolve(T x) {
        return this.helper.resolve(x);
    }

    @Override
    public <T> Promise<T> resolve(Thenable<T> x) {
        return this.helper.resolve(x);
    }

    @Override
    public <T> Promise<T> reject(Throwable x) {
        return this.helper.reject(x);
    }

    @Override
    public <T> Promise<T> promise(PromiseResolver<T> resolver) {
        return new TrustedPromise<T>(resolver, this.helper);
    }

    private <T, U> Promise<U> _apply(Function<List<T>, Thenable<U>> f, List<Thenable<T>> args) {
        return this.helper.all(args).then(f::apply);
    }

    @Override
    public <T> Deferred<T> defer() {
        return new DeferredImpl();
    }

    @Override
    public <T> Promise<List<T>> join(Promise<T> ... promises) {
        return this.helper.all(Arrays.asList(promises));
    }

    @Override
    public <T> Promise<List<T>> all(List<? extends Thenable<T>> promises) {
        return this.when(promises, this.helper::all);
    }

    @Override
    public <T> Promise<List<State<T>>> settle(List<? extends Thenable<T>> promises) {
        return this.when(promises, this.arrayHelper::settle);
    }

    @Override
    public <T> Promise<T> any(List<? extends Thenable<T>> promises) {
        return this.when(promises, this.arrayHelper::any);
    }

    @Override
    public <T> Promise<List<T>> some(List<? extends Thenable<T>> promises, int n) {
        return this.arrayHelper.some(promises, n);
    }

    @Override
    public <T> Promise<List<T>> map(List<? extends Thenable<T>> promises, Function<T, ? extends Thenable<T>> mapFunc) {
        return this.when(promises, (T promises1) -> this.arrayHelper.map(promises1, mapFunc, null));
    }

    @Override
    public <T> Promise<T> reduce(List<? extends Thenable<T>> promises, BiFunction<T, T, ? extends Thenable<T>> f) {
        return this.when(promises, (T promises1) -> this.arrayHelper.reduce(promises1, f));
    }

    @Override
    public <T, U> Promise<U> reduce(List<? extends Thenable<T>> promises, BiFunction<U, T, ? extends Thenable<U>> f, Thenable<U> initialValue) {
        return this.when(promises, (T promises1) -> this.arrayHelper.reduce(promises1, f, initialValue));
    }

    @Override
    public <T, U> Promise<List<U>> sequence(List<Function<T, Thenable<U>>> tasks, Thenable<T> arg) {
        ArrayList results = new ArrayList();
        ArrayList promises = new ArrayList(tasks.size());
        tasks.stream().forEach(task -> promises.add(this.resolve(task)));
        Function<Object, Thenable> addResult = result -> {
            results.add(result);
            return this.resolve(results);
        };
        return this.resolve(arg).then(argResult -> this.reduce(promises, (results1, task) -> this.when((Thenable)task.apply(argResult), addResult), this.resolve(results)));
    }

    @Override
    public <T> Promise<T> race(List<? extends Thenable<T>> promises) {
        return this.helper.race(promises);
    }

    private class DeferredImpl<T>
    implements Deferred<T> {
        private final TrustedPromise<T> promise;

        public DeferredImpl() {
            this.promise = DefaultWhen.this.helper.defer();
        }

        @Override
        public Resolver<T> getResolver() {
            return this;
        }

        @Override
        public Promise<T> getPromise() {
            return this.promise;
        }

        @Override
        public void resolve(T x) {
            this.promise._handler.resolve(x);
        }

        @Override
        public void resolve(Thenable<T> x) {
            this.promise._handler.resolve(x);
        }

        @Override
        public void reject(Throwable x) {
            this.promise._handler.reject(x);
        }
    }
}

