/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.internal;

import com.englishtown.promises.Promise;
import com.englishtown.promises.PromiseResolver;
import com.englishtown.promises.State;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.exceptions.RejectException;
import com.englishtown.promises.internal.PromiseHelper;
import com.englishtown.promises.internal.TrustedPromise;
import com.englishtown.promises.internal.ValueHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ArrayHelper {
    private final PromiseHelper helper;

    @Inject
    public ArrayHelper(PromiseHelper helper) {
        this.helper = helper;
    }

    public <T> Promise<T> any(List<? extends Thenable<T>> promises) {
        PromiseResolver resolver = (resolve, reject) -> {
            ValueHolder<Integer> pending = new ValueHolder<Integer>(promises.size());
            ArrayList errors = new ArrayList();
            Function<Object, Promise> handleResolve = x -> {
                resolve.accept(x);
                return null;
            };
            Function<Throwable, Promise> handleReject = e -> {
                errors.add(e);
                valueHolder.value = (Integer)valueHolder.value - 1;
                if ((Integer)valueHolder.value == 0) {
                    reject.accept(new RejectException("All promises rejected", errors));
                }
                return null;
            };
            promises.forEach(p -> this.helper.toPromise(p).then(handleResolve, handleReject));
            if ((Integer)pending.value == 0) {
                resolve.accept(null);
            }
        };
        return new TrustedPromise(resolver, this.helper);
    }

    public <T> Promise<List<T>> some(List<? extends Thenable<T>> promises, int n) {
        int nFinal = Math.max(n, 0);
        return new TrustedPromise<List<T>>((resolve, reject) -> {
            ValueHolder<Integer> nFulfill = new ValueHolder<Integer>(0);
            ValueHolder<Object> nReject = new ValueHolder<Object>(null);
            ArrayList results = new ArrayList(nFinal);
            ArrayList errors = new ArrayList();
            Function<Object, Promise> handleResolve = x -> {
                if ((Integer)valueHolder.value > 0) {
                    valueHolder.value = (Integer)valueHolder.value - 1;
                    results.add(x);
                    if ((Integer)valueHolder.value == 0) {
                        resolve.accept(results);
                    }
                }
                return null;
            };
            Function<Throwable, Promise> handleReject = e -> {
                if ((Integer)valueHolder.value > 0) {
                    valueHolder.value = (Integer)valueHolder.value - 1;
                    errors.add(e);
                    if ((Integer)valueHolder.value == 0) {
                        reject.accept(new RejectException("Too many rejections", errors));
                    }
                }
                return null;
            };
            nReject.value = promises.size() - nFinal + 1;
            nFulfill.value = Math.min(nFinal, promises.size());
            if ((Integer)nFulfill.value == 0) {
                resolve.accept(results);
                return;
            }
            promises.stream().forEach(p -> this.helper.toPromise(p).then(handleResolve, handleReject));
        }, this.helper);
    }

    public <T> Promise<List<T>> map(List<? extends Thenable<T>> promises, Function<T, ? extends Thenable<T>> f, Function<Throwable, ? extends Thenable<T>> fallback) {
        return this.helper.all(promises.stream().map(x -> this.helper.toPromise(x).then(f, fallback)).collect(Collectors.toList()));
    }

    public <T> Promise<List<State<T>>> settle(List<? extends Thenable<T>> promises) {
        return this.helper.all(promises.stream().map(p -> {
            TrustedPromise p1 = this.helper.toPromise(p);
            return p1.then(x -> this.helper.resolve(p1.inspect()), t -> this.helper.resolve(p1.inspect()));
        }).collect(Collectors.toList()));
    }

    public <T> Promise<T> reduce(List<? extends Thenable<T>> promises, BiFunction<T, T, ? extends Thenable<T>> f) {
        List<Thenable<T>> thenables = promises;
        return (Promise)thenables.stream().reduce((result, x) -> this.helper.toPromise(result).then(r -> this.helper.toPromise(x).then(x1 -> (Thenable)f.apply(r, x1)))).get();
    }

    public <T, U> Promise<U> reduce(List<? extends Thenable<T>> promises, BiFunction<U, T, ? extends Thenable<U>> f, Thenable<U> initialValue) {
        List<Thenable<T>> thenables = promises;
        return (Promise)thenables.stream().reduce(initialValue, (U result, ? super T x) -> this.helper.toPromise(result).then(r -> this.helper.toPromise(x).then(x1 -> (Thenable)f.apply(r, x1))), (c1, c2) -> c1);
    }
}

