/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.internal;

import com.englishtown.promises.Promise;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.internal.handlers.Handler;
import java.util.function.Function;

public class AssimilateTask<T, U>
implements Runnable {
    private final Thenable<T> thenable;
    private final Handler<T> resolver;

    public AssimilateTask(Thenable<T> thenable, Handler<T> resolver) {
        this.thenable = thenable;
        this.resolver = resolver;
    }

    @Override
    public void run() {
        Handler h = this.resolver;
        Function<Object, Promise> _resolve = x -> {
            h.resolve(x);
            return null;
        };
        Function<Throwable, Promise<U>> _reject = x -> {
            h.reject((Throwable)x);
            return null;
        };
        this.tryAssimilate(this.thenable, _resolve, _reject);
    }

    private void tryAssimilate(Thenable<T> thenable, Function<T, Promise<U>> resolve, Function<Throwable, Promise<U>> reject) {
        try {
            thenable.then(resolve, reject);
        }
        catch (Throwable e) {
            reject.apply(e);
        }
    }
}

