/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.internal;

import com.englishtown.promises.Context;
import com.englishtown.promises.Environment;
import com.englishtown.promises.HandlerState;
import com.englishtown.promises.Promise;
import com.englishtown.promises.Reporter;
import com.englishtown.promises.Scheduler;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.internal.TrustedPromise;
import com.englishtown.promises.internal.ValueHolder;
import com.englishtown.promises.internal.handlers.AsyncHandler;
import com.englishtown.promises.internal.handlers.DeferredHandler;
import com.englishtown.promises.internal.handlers.FulfilledHandler;
import com.englishtown.promises.internal.handlers.Handler;
import com.englishtown.promises.internal.handlers.RejectedHandler;
import com.englishtown.promises.internal.handlers.ThenableHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;

public class PromiseHelper {
    private final Scheduler scheduler;
    private final Context context;
    private final Reporter reporter;
    private final Promise<Object> foreverPendingPromise;

    @Inject
    public PromiseHelper(Environment environment, Context context, Reporter reporter) {
        this.scheduler = environment.getScheduler();
        this.context = context;
        this.reporter = reporter;
        Handler<Object> foreverPendingHandler = new Handler<Object>(this){};
        this.foreverPendingPromise = new TrustedPromise<Object>(foreverPendingHandler, this);
    }

    public <T> TrustedPromise<T> resolve(T x) {
        return this.resolve0(x);
    }

    public <T> TrustedPromise<T> resolve(Thenable<T> x) {
        return this.resolve0(x);
    }

    private <T> TrustedPromise<T> resolve0(Object x) {
        return this.isPromise(x) ? (TrustedPromise)x : new TrustedPromise<T>(new AsyncHandler<T>(this.getHandler(x), this), this);
    }

    <T> TrustedPromise<T> toPromise(T x) {
        return this.resolve0(x);
    }

    <T> TrustedPromise<T> toPromise(Thenable<T> x) {
        return this.resolve0(x);
    }

    public <T> TrustedPromise<T> reject(Throwable x) {
        return new TrustedPromise(new AsyncHandler(new RejectedHandler(x, this), this), this);
    }

    public <T> Promise<T> never() {
        return this.foreverPendingPromise;
    }

    public <T> TrustedPromise<T> defer() {
        return new TrustedPromise(new DeferredHandler(this, null), this);
    }

    public <T> Handler<T> getHandler(Object x) {
        if (this.isPromise(x)) {
            return ((TrustedPromise)x)._handler.join();
        }
        return this.maybeThenable(x) ? this.getHandlerUntrusted((Thenable)x) : new FulfilledHandler<Object>(x, this);
    }

    public boolean isPromise(Object x) {
        return x instanceof TrustedPromise;
    }

    public boolean maybeThenable(Object x) {
        return x instanceof Thenable;
    }

    private <T> Handler<T> getHandlerUntrusted(Thenable<T> x) {
        try {
            return x != null ? new ThenableHandler<T>(x, this) : new FulfilledHandler<Object>(null, this);
        }
        catch (Throwable e) {
            return new RejectedHandler(e, this);
        }
    }

    public <T, U> Thenable<U> tryCatchReject(Function<T, ? extends Thenable<U>> f, T x) {
        try {
            return f.apply(x);
        }
        catch (Throwable e) {
            return this.reject(e);
        }
    }

    public <T, U, V> Thenable<V> tryCatchReject2(BiFunction<T, U, ? extends Thenable<V>> f, T x, U y) {
        try {
            return f.apply(x, y);
        }
        catch (Throwable e) {
            return this.reject(e);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Context getContext() {
        return this.context;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public <T> Promise<List<T>> all(List<? extends Thenable<T>> promises) {
        DeferredHandler resolver = new DeferredHandler(this, null);
        ValueHolder<Integer> pending = new ValueHolder<Integer>(promises == null ? 0 : promises.size());
        ArrayList results = new ArrayList((Integer)pending.value);
        BiConsumer<DeferredHandler, Integer> resolveOne = (handler, i) -> handler.map(x -> {
            results.set((int)i, x);
            valueHolder.value = (Integer)valueHolder.value - 1;
            if ((Integer)valueHolder.value == 0) {
                resolver.become(new FulfilledHandler<List>(results, this));
            }
        }, resolver);
        if (promises == null) {
            throw new IllegalArgumentException("promises cannot be null");
        }
        block5: for (int i2 = 0; i2 < promises.size(); ++i2) {
            Thenable<T> x = promises.get(i2);
            results.add(i2, null);
            if (x == null) {
                ValueHolder<Integer> valueHolder = pending;
                Integer.valueOf((Integer)valueHolder.value - 1);
                valueHolder.value = valueHolder.value;
                continue;
            }
            Handler<T> h = this.isPromise(x) ? ((TrustedPromise)x)._handler.join() : this.getHandlerUntrusted(x);
            HandlerState s = h.state();
            switch (s) {
                case PENDING: {
                    resolveOne.accept((DeferredHandler)h, i2);
                    continue block5;
                }
                case FULFILLED: {
                    results.set(i2, ((FulfilledHandler)h).getValue());
                    ValueHolder<Integer> valueHolder = pending;
                    Integer.valueOf((Integer)valueHolder.value - 1);
                    valueHolder.value = valueHolder.value;
                    continue block5;
                }
                case REJECTED: {
                    resolver.reject(((RejectedHandler)h).getValue());
                    i2 = promises.size();
                }
            }
        }
        if ((Integer)pending.value == 0) {
            resolver.become(new FulfilledHandler(results, this));
        }
        return new TrustedPromise<List<T>>(resolver, this);
    }

    public <T> Promise<T> race(List<? extends Thenable<T>> promises) {
        if (promises.size() == 0) {
            return this.never();
        }
        DeferredHandler h = new DeferredHandler(this, null);
        for (int i = 0; i < promises.size(); ++i) {
            Thenable<T> x = promises.get(i);
            if (x == null) continue;
            this.getHandler(x).chain(h::resolve, h::reject);
        }
        return new TrustedPromise(h, this);
    }
}

