/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.internal;

import com.englishtown.promises.HandlerState;
import com.englishtown.promises.Promise;
import com.englishtown.promises.PromiseResolver;
import com.englishtown.promises.State;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.exceptions.RejectException;
import com.englishtown.promises.internal.Continuation;
import com.englishtown.promises.internal.PromiseHelper;
import com.englishtown.promises.internal.handlers.DeferredHandler;
import com.englishtown.promises.internal.handlers.Handler;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class TrustedPromise<T>
implements Promise<T> {
    public final Handler<T> _handler;
    private final PromiseHelper helper;

    public TrustedPromise(Handler<T> handler, PromiseHelper helper) {
        this._handler = handler;
        this.helper = helper;
    }

    public TrustedPromise(PromiseResolver<T> resolver, PromiseHelper helper) {
        this.helper = helper;
        this._handler = this.init(resolver);
    }

    private DeferredHandler<T> init(PromiseResolver<T> resolver) {
        DeferredHandler handler = new DeferredHandler(this.helper, null);
        try {
            resolver.resolve(handler::resolve, handler::reject);
        }
        catch (Throwable e) {
            handler.reject(e);
        }
        return handler;
    }

    @Override
    public <U> Promise<U> then(Function<T, ? extends Thenable<U>> onFulfilled) {
        return this.then((Function)onFulfilled, (Function)null);
    }

    @Override
    public <U> Promise<U> then(Function<T, ? extends Thenable<U>> onFulfilled, Function<Throwable, ? extends Thenable<U>> onRejected) {
        Handler parent = this._handler;
        if (onFulfilled == null && parent.join().state() == HandlerState.FULFILLED) {
            return new TrustedPromise<T>(parent, this.helper);
        }
        TrustedPromise<U> p = this._beget();
        Handler<T> child = p._handler;
        Continuation cont = new Continuation();
        cont.resolve = child::resolve;
        cont.context = child;
        cont.fulfilled = onFulfilled;
        cont.rejected = onRejected;
        parent.when(cont);
        return p;
    }

    private <U> TrustedPromise<U> _beget() {
        Handler<T> parent = this._handler;
        DeferredHandler child = new DeferredHandler(this.helper, parent.join().context);
        return new TrustedPromise(child, this.helper);
    }

    private void _maybeFatal(Thenable<?> x) {
        if (!this.helper.maybeThenable(x)) {
            return;
        }
        Handler handler = this.helper.getHandler(x);
        Object context = this._handler.context;
        handler.catchError(t -> handler._fatal(context), handler);
    }

    @Override
    public State<T> inspect() {
        return this._handler.inspect();
    }

    @Override
    public <U> void done(Function<T, ? extends Thenable<U>> onResult, Function<Throwable, ? extends Thenable<U>> onError) {
        Handler h = this._handler;
        Continuation cont = new Continuation();
        cont.resolve = this::_maybeFatal;
        cont.context = this;
        cont.fulfilled = onResult;
        cont.rejected = onError;
        h.when(cont);
    }

    @Override
    public <U> Promise<U> otherwise(Function<Throwable, ? extends Thenable<U>> onRejected) {
        return this.then((Function)null, (Function)onRejected);
    }

    @Override
    public <U> Promise<U> otherwise(Predicate<Throwable> predicate, Function<Throwable, ? extends Thenable<U>> onRejected) {
        if (predicate == null) {
            return this.otherwise(onRejected);
        }
        if (onRejected == null) {
            return this.ensure(this::rejectInvalidPredicate);
        }
        return this.otherwise(this.createCatchFilter(onRejected, predicate));
    }

    @Override
    public <U> Promise<U> otherwise(Class<? extends Throwable> type, Function<Throwable, ? extends Thenable<U>> onRejected) {
        return this.otherwise(type::isInstance, onRejected);
    }

    private <U> Function<Throwable, ? extends Thenable<U>> createCatchFilter(Function<Throwable, ? extends Thenable<U>> handler, Predicate<Throwable> predicate) {
        return e -> predicate.test((Throwable)e) ? (TrustedPromise)handler.apply((Throwable)e) : this.helper.reject((Throwable)e);
    }

    @Override
    public Promise<T> ensure(Runnable handler) {
        if (handler == null) {
            return this;
        }
        return this.then((T x) -> {
            handler.run();
            return this;
        }, (T t) -> {
            handler.run();
            return this;
        });
    }

    @Override
    public <U> Promise<U> orElse(Thenable<U> defaultValue) {
        return this.then((Function)null, (T t) -> defaultValue);
    }

    @Override
    public <U> Promise<U> yield(Thenable<U> value) {
        return this.then((T x) -> value);
    }

    @Override
    public Promise<T> tap(Function<T, Thenable<T>> onFulfilledSideEffect) {
        return this.then(onFulfilledSideEffect).yield(this);
    }

    private void rejectInvalidPredicate() {
        throw new RejectException("catch predicate must be a function");
    }

    @Override
    public <U, V> Promise<V> fold(BiFunction<U, T, ? extends Thenable<V>> fn, Thenable<U> arg) {
        TrustedPromise<U> promise = this._beget();
        this._handler.fold(promise._handler, fn, arg);
        return promise;
    }
}

