/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.internal.handlers;

import com.englishtown.promises.State;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.internal.Continuation;
import com.englishtown.promises.internal.ContinuationTask;
import com.englishtown.promises.internal.PromiseHelper;
import com.englishtown.promises.internal.handlers.CycleHandler;
import com.englishtown.promises.internal.handlers.Handler;
import com.englishtown.promises.internal.handlers.RejectedHandler;
import java.util.ArrayList;
import java.util.List;

public class DeferredHandler<T>
extends Handler<T>
implements Runnable {
    private boolean resolved;
    private List<Continuation<T, ?>> consumers;
    private final Object lock = new Object();

    public DeferredHandler(PromiseHelper helper, Object inheritedContext) {
        super(helper);
        helper.getContext().createContext(this, inheritedContext);
        this.handler = null;
        this.resolved = false;
    }

    @Override
    public State<T> inspect() {
        return this.resolved ? this.join().inspect() : this.toPendingState();
    }

    @Override
    public void resolve(T x) {
        this.resolve0(x);
    }

    @Override
    public void resolve(Thenable<T> x) {
        this.resolve0(x);
    }

    private void resolve0(Object x) {
        if (!this.resolved) {
            this.become(this.helper.getHandler(x));
        }
    }

    @Override
    public void reject(Throwable x) {
        if (!this.resolved) {
            this.become(new RejectedHandler(x, this.helper));
        }
    }

    @Override
    public Handler<T> join() {
        if (this.resolved) {
            Handler h = this;
            while (h.handler != null) {
                h = h.handler;
                if (h != this) continue;
                this.handler = new CycleHandler(this.helper);
                return this.handler;
            }
            return h;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Continuation<Continuation, ?>> q = this.consumers;
        Handler<T> handler = this.join();
        Object object = this.lock;
        synchronized (object) {
            this.consumers = null;
        }
        q.forEach(handler::when);
    }

    public void become(Handler<T> handler) {
        this.resolved = true;
        this.handler = handler;
        if (this.consumers != null) {
            this.helper.getScheduler().enqueue(this);
        }
        if (this.context != null) {
            handler._report(this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void when(Continuation<T, ?> continuation) {
        if (this.resolved) {
            this.helper.getScheduler().enqueue(new ContinuationTask<T>(continuation, this.handler));
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.consumers == null) {
                    this.consumers = new ArrayList();
                }
                this.consumers.add(continuation);
            }
        }
    }

    @Override
    protected void _report(Object context) {
        if (this.resolved) {
            this.handler.join()._report(context);
        }
    }

    @Override
    protected void _unreport() {
        if (this.resolved) {
            this.handler.join()._unreport();
        }
    }

    @Override
    public void _fatal(Object context) {
        Object c;
        Object object = c = context == null ? this.context : context;
        if (this.resolved) {
            this.handler.join()._fatal(c);
        }
    }
}

