/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.internal.handlers;

import com.englishtown.promises.HandlerState;
import com.englishtown.promises.State;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.internal.Continuation;
import com.englishtown.promises.internal.PromiseHelper;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public abstract class Handler<T> {
    protected final PromiseHelper helper;
    protected Handler<T> handler;
    public Object context;
    protected HandlerState _state;

    public Handler(PromiseHelper helper) {
        this.helper = helper;
        this._state = HandlerState.PENDING;
    }

    public void when(Continuation<T, ?> continuation) {
    }

    public void resolve(T x) {
    }

    public void resolve(Thenable<T> x) {
    }

    public void reject(Throwable cause) {
    }

    public void _fatal(Object context) {
    }

    protected void _unreport() {
    }

    protected void _report(Object context) {
    }

    public State<T> inspect() {
        return this.toPendingState();
    }

    protected State<T> toPendingState() {
        return new State(HandlerState.PENDING);
    }

    public HandlerState state() {
        return this._state;
    }

    public Handler<T> join() {
        Handler<T> h = this;
        while (h.handler != null) {
            h = h.handler;
        }
        return h;
    }

    public void chain(Consumer<T> fulfilled, Consumer<Throwable> rejected) {
        Continuation cont = new Continuation();
        cont.resolve = x -> {};
        cont.context = null;
        cont.fulfilled = fulfilled == null ? null : x -> {
            fulfilled.accept(x);
            return null;
        };
        cont.rejected = rejected == null ? null : x -> {
            rejected.accept((Throwable)x);
            return null;
        };
        this.when(cont);
    }

    public void map(Consumer<T> f, Handler<?> to) {
        this.chain(f, to::reject);
    }

    public void catchError(Consumer<Throwable> f, Handler<T> to) {
        this.chain(to::resolve, f);
    }

    public <U, V> void fold(Handler<V> to, BiFunction<U, T, ? extends Thenable<V>> f, Thenable<U> z) {
        this.join().map(x -> this.helper.getHandler(z).map(z1 -> to.resolve(this.helper.tryCatchReject2(f, z1, x)), to), to);
    }
}

