/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.promises.internal.handlers;

import com.englishtown.promises.HandlerState;
import com.englishtown.promises.Reporter;
import com.englishtown.promises.State;
import com.englishtown.promises.Thenable;
import com.englishtown.promises.internal.Continuation;
import com.englishtown.promises.internal.PromiseHelper;
import com.englishtown.promises.internal.TrustedPromise;
import com.englishtown.promises.internal.handlers.Handler;

public class RejectedHandler<T>
extends Handler<T> {
    private final Throwable value;
    private final Reporter reporter;
    private boolean handled;
    private boolean reported;

    public RejectedHandler(Throwable x, PromiseHelper helper) {
        super(helper);
        this.reporter = helper.getReporter();
        this._state = HandlerState.REJECTED;
        helper.getContext().createContext(this);
        this.value = x;
        this.handled = false;
        this.reported = false;
        this._report(null);
    }

    @Override
    public State<T> inspect() {
        return new State(this._state, this.value);
    }

    @Override
    public void when(Continuation<T, ?> cont) {
        Thenable<Object> x;
        if (cont.rejected != null) {
            this._unreport();
            this.helper.getContext().enterContext(this);
            x = this.helper.tryCatchReject(cont.rejected, this.value);
            this.helper.getContext().exitContext();
        } else {
            x = new TrustedPromise(this, this.helper);
        }
        cont.resolve.accept(x);
    }

    @Override
    protected void _report(Object context) {
        this.helper.getScheduler().afterQueue(this::reportUnhandled);
    }

    @Override
    protected void _unreport() {
        this.handled = true;
        this.helper.getScheduler().afterQueue(this::reportHandled);
    }

    @Override
    public void _fatal(Object context) {
        this.reporter.onFatalRejection(this, context);
    }

    private void reportUnhandled() {
        if (!this.handled) {
            this.reported = true;
            this.reporter.onPotentiallyUnhandledRejection(this, this.context);
        }
    }

    private void reportHandled() {
        if (this.reported) {
            this.reporter.onPotentiallyUnhandledRejectionHandled(this);
        }
    }

    public Throwable getValue() {
        return this.value;
    }

    public boolean handled() {
        return this.handled;
    }
}

