/*
 * Decompiled with CFR 0.152.
 */
package com.eorghe.hyperapi.common;

import com.eorghe.hyperapi.processor.annotations.HyperResource;
import com.eorghe.hyperapi.registry.EntityRegistry;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.NotFoundException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ApplicationScoped
public class EntityConfigProvider {
    @Inject
    private EntityRegistry registry;
    private final Map<Class<?>, HyperResource> config = new ConcurrentHashMap();

    public HyperResource configFor(Class<?> cls) {
        return this.config.computeIfAbsent(cls, c -> {
            HyperResource ann = c.getAnnotation(HyperResource.class);
            if (ann == null) {
                throw new IllegalStateException("Entity not @HyperResource: " + String.valueOf(c));
            }
            return ann;
        });
    }

    public Class<?> resolve(String simple) {
        return this.registry.bySimpleName(simple).orElseThrow(() -> new NotFoundException("Entity not found: " + simple));
    }
}

