/*
 * Decompiled with CFR 0.152.
 */
package com.eorghe.hyperapi.controller;

import com.eorghe.hyperapi.dto.HyperDto;
import com.eorghe.hyperapi.mapper.AbstractMapper;
import com.eorghe.hyperapi.model.HyperEntity;
import com.eorghe.hyperapi.service.BaseEntityService;
import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public abstract class RestController<DTO extends HyperDto, MAPPER extends AbstractMapper<DTO, ENTITY>, ENTITY extends HyperEntity> {
    protected abstract BaseEntityService<ENTITY, DTO, MAPPER> getService();

    @GET
    public List<DTO> getAll(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="20") int limit) {
        return this.getService().findAll(offset, limit);
    }

    @GET
    @Path(value="/{id}")
    public Response getById(@PathParam(value="id") Long id) {
        DTO dto = this.getService().findById(id);
        if (dto == null) {
            throw new NotFoundException("Entity not found");
        }
        return Response.ok(dto).build();
    }

    @POST
    public Response create(DTO dto) {
        return Response.status((Response.Status)Response.Status.CREATED).entity(this.getService().create(dto)).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") Long id, DTO dto) {
        ((HyperDto)dto).setId(id);
        return Response.ok(this.getService().update(dto)).build();
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/merge-patch+json"})
    public Response patch(@PathParam(value="id") Long id, JsonObject patchJson) {
        DTO patchedDto = this.getService().patch(id, patchJson);
        return Response.ok(patchedDto).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) {
        this.getService().delete(id);
        return Response.noContent().build();
    }
}

