/*
 * Decompiled with CFR 0.152.
 */
package com.eorghe.hyperapi.controller.filters;

import com.eorghe.hyperapi.common.EntityConfigProvider;
import com.eorghe.hyperapi.controller.filters.ApiError;
import com.eorghe.hyperapi.processor.annotations.Secured;
import com.eorghe.hyperapi.processor.annotations.Security;
import com.eorghe.hyperapi.registry.EntityRegistry;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

@Secured
@Provider
@Priority(value=2000)
public class SecurityFilter
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(SecurityFilter.class);
    @Inject
    EntityRegistry registry;
    @Inject
    EntityConfigProvider cfgProv;
    @Context
    UriInfo uriInfo;
    @Context
    SecurityContext securityContext;

    public void filter(ContainerRequestContext ctx) throws IOException {
        String method = ctx.getMethod();
        if ("OPTIONS".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            return;
        }
        String entityName = (String)this.uriInfo.getPathParameters().getFirst((Object)"entity");
        if (entityName == null) {
            return;
        }
        Optional<Class<?>> opt = this.registry.bySimpleName(entityName);
        if (opt.isEmpty()) {
            return;
        }
        Class<?> cls = opt.get();
        Security sec = this.cfgProv.configFor(cls).security();
        if (!sec.requireAuth() && sec.rolesAllowed().length == 0) {
            return;
        }
        if (sec.requireAuth() && this.securityContext.getUserPrincipal() == null) {
            log.warnf("Unauthenticated request to %s at %s", (Object)entityName, (Object)this.uriInfo.getRequestUri());
            ctx.abortWith(this.buildError(Response.Status.UNAUTHORIZED, "Unauthorized", "Authentication required", this.uriInfo.getPath(), true));
            return;
        }
        Set<String> allowed = Set.of(sec.rolesAllowed());
        if (!allowed.isEmpty()) {
            boolean hasRole = allowed.stream().anyMatch(arg_0 -> ((SecurityContext)this.securityContext).isUserInRole(arg_0));
            if (!hasRole) {
                log.warnf("Forbidden request to %s by user %s", (Object)entityName, (Object)this.securityContext.getUserPrincipal().getName());
                ctx.abortWith(this.buildError(Response.Status.FORBIDDEN, "Forbidden", "Access denied for entity " + entityName, this.uriInfo.getPath(), false));
                return;
            }
        }
    }

    private Response buildError(Response.Status status, String error, String message, String path, boolean sendAuthHeader) {
        ApiError payload = new ApiError(Instant.now().toString(), status.getStatusCode(), error, message, path);
        Response.ResponseBuilder rb = Response.status((Response.Status)status).entity((Object)payload).type("application/json");
        if (sendAuthHeader) {
            rb.header("WWW-Authenticate", (Object)"Bearer realm=\"hyperapi\"");
        }
        return rb.build();
    }
}

