/*
 * Decompiled with CFR 0.152.
 */
package com.eorghe.hyperapi.llm;

import com.eorghe.hyperapi.llm.LLMDocService;
import com.eorghe.hyperapi.llm.OllamaRestClient;
import com.eorghe.hyperapi.processor.annotations.HyperResource;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;

@ApplicationScoped
public class OllamaLLMDocService
implements LLMDocService {
    private static final org.jboss.logging.Logger LOG = org.jboss.logging.Logger.getLogger(OllamaLLMDocService.class);
    ObjectMapper mapper = new ObjectMapper();
    @Inject
    OllamaRestClient restClient;
    private final String model = ConfigProvider.getConfig().getOptionalValue("hyperapi.llm.ollama.model", String.class).orElse("llama3");

    @Override
    public Uni<String> generateOpenApiDoc(String prompt) {
        return Uni.createFrom().item(() -> {
            ObjectNode payload = this.mapper.createObjectNode();
            payload.put("model", this.model);
            payload.put("prompt", prompt);
            return payload;
        }).runSubscriptionOn(Infrastructure.getDefaultExecutor()).map(payload -> {
            try {
                String response = this.restClient.sendPrompt((ObjectNode)payload);
                StringBuilder fullResponse = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new StringReader(response));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        JsonNode chunk = this.mapper.readTree(line);
                        fullResponse.append(chunk.path("response").asText());
                        if (!chunk.path("done").asBoolean(false)) continue;
                        break;
                    }
                }
                catch (IOException e) {
                    return "[ERROR: Failed to parse LLM response]";
                }
                return fullResponse.toString();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to call Ollama", (Throwable)e);
                return "[ERROR] Could not generate documentation";
            }
        });
    }

    @Override
    public Uni<String> generateFor(Class<?> entity) {
        String prompt = "";
        try {
            prompt = this.buildPrompt(entity);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(OllamaLLMDocService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.generateOpenApiDoc(prompt);
    }

    private String buildPrompt(Class<?> entity) throws ClassNotFoundException {
        Set<Object> ignoredFields = Set.of();
        HyperResource annotation = entity.getAnnotation(HyperResource.class);
        if (annotation != null && annotation.dto() != "") {
            entity = Class.forName(annotation.dto());
        } else {
            assert (annotation != null);
            ignoredFields = Set.of(annotation.mapping().ignore());
        }
        StringBuilder sb = new StringBuilder(" Generate a complete OpenAPI3.0 schema given the provided information bellow. No additional text, just the schema.\n");
        sb.append("\n\nClass: ").append(entity.getSimpleName()).append("\nFields:\n");
        for (Field field : entity.getDeclaredFields()) {
            if (field.getName().startsWith("$$") || Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || ignoredFields.contains(field.getName())) continue;
            sb.append("- ").append(field.getName()).append(" (type: ").append(field.getType().getSimpleName()).append(")\n");
        }
        return sb.toString();
    }
}

