/*
 * Decompiled with CFR 0.152.
 */
package com.eorghe.hyperapi.model;

import io.quarkus.hibernate.orm.panache.PanacheEntity;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@MappedSuperclass
public abstract class HyperEntity
extends PanacheEntity {
    private String createdBy;
    private String updatedBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @Column(name="UPDATED_ON")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updatedOn;

    @PrePersist
    public void prePersist() {
        this.createdOn = new Date();
        this.updatedOn = new Date();
    }

    @PreUpdate
    public void preUpdate() {
        this.updatedOn = new Date();
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public void setUpdatedOn(Date updatedOn) {
        this.updatedOn = updatedOn;
    }
}

