/*
 * Decompiled with CFR 0.152.
 */
package com.eorghe.hyperapi.processor;

import com.eorghe.hyperapi.processor.PropertyGenerator;
import com.eorghe.hyperapi.processor.annotations.Events;
import com.eorghe.hyperapi.processor.annotations.HyperResource;
import com.eorghe.hyperapi.processor.enums.HttpMethod;
import com.eorghe.hyperapi.processor.enums.Scope;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Generated;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.eorghe.hyperapi.processor.annotations.HyperResource"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
@AutoService(value={Processor.class})
public class HyperApiProcessor
extends AbstractProcessor {
    public static final String DEV_HYPERAPI_RUNTIME_CORE_ENTITY = "com.eorghe.hyperapi.model.HyperEntity";
    public static final String DEV_HYPERAPI_RUNTIME_CORE_ENTITY_DTO = "com.eorghe.hyperapi.dto.HyperDto";
    private Filer filer;
    private Messager messager;
    private Elements elementUtils;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.filer = env.getFiler();
        this.messager = env.getMessager();
        this.elementUtils = env.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(HyperResource.class)) {
            boolean shouldGenerate;
            if (!(element instanceof TypeElement)) {
                this.error(element, "@HyperResource must annotate a class.");
                continue;
            }
            TypeElement entityType = (TypeElement)element;
            if (!this.isExtendingBaseEntity(entityType)) {
                this.error(entityType, "Class %s must extend %s to use @HyperResource", DEV_HYPERAPI_RUNTIME_CORE_ENTITY, entityType.getSimpleName().toString());
                return false;
            }
            HyperResource hyperResource = entityType.getAnnotation(HyperResource.class);
            String dtoName = this.sanitizeDtoName(entityType.getSimpleName().toString(), hyperResource.dto());
            List<String> ignoredFields = Arrays.asList(hyperResource.mapping().ignore());
            List<String> ignoredNestedFields = Arrays.asList(hyperResource.mapping().ignoreNested());
            boolean bl = shouldGenerate = !dtoName.isBlank() || !ignoredFields.isEmpty();
            if (!shouldGenerate) {
                this.info(entityType, "Skipping generation for " + String.valueOf(entityType.getSimpleName()));
                continue;
            }
            try {
                this.generateDTO(entityType, dtoName, ignoredFields);
                this.generateMapper(entityType, dtoName, ignoredFields, ignoredNestedFields);
                this.generateService(entityType, dtoName, hyperResource);
                this.generateController(entityType, dtoName, hyperResource);
            }
            catch (IOException | ClassNotFoundException e) {
                this.error(entityType, "Code generation failed: " + e.getMessage());
            }
        }
        return true;
    }

    private boolean isExtendingBaseEntity(TypeElement typeElement) {
        TypeElement baseEntityType = this.elementUtils.getTypeElement(DEV_HYPERAPI_RUNTIME_CORE_ENTITY);
        if (baseEntityType == null) {
            this.error(typeElement, "Could not resolve BaseEntity class in classpath");
            return false;
        }
        return typeElement.getSuperclass().toString().equals(baseEntityType.getQualifiedName().toString());
    }

    private void generateMapper(TypeElement entity, String dtoName, List<String> ignore, List<String> ignoreNested) throws IOException {
        String entityName = entity.getSimpleName().toString();
        String basePackage = this.elementUtils.getPackageOf(entity).getQualifiedName().toString();
        String mapperName = entityName + "Mapper";
        ClassName dtoClass = ClassName.get((String)(basePackage + ".dto"), (String)dtoName, (String[])new String[0]);
        ClassName entityClass = ClassName.get((String)basePackage, (String)entityName, (String[])new String[0]);
        ParameterizedTypeName superType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"com.eorghe.hyperapi.mapper", (String)"AbstractMapper", (String[])new String[0]), (TypeName[])new TypeName[]{dtoClass, entityClass});
        ArrayList<AnnotationSpec> mappingAnnotations = new ArrayList<AnnotationSpec>();
        for (String nested : ignoreNested) {
            mappingAnnotations.add(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"Mapping", (String[])new String[0])).addMember("target", "$S", new Object[]{nested}).addMember("ignore", "true", new Object[0]).build());
        }
        MethodSpec.Builder toEntityBuilder = MethodSpec.methodBuilder((String)"toEntity").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)entityClass).addParameter((TypeName)dtoClass, "dto", new Modifier[0]);
        mappingAnnotations.forEach(arg_0 -> ((MethodSpec.Builder)toEntityBuilder).addAnnotation(arg_0));
        MethodSpec.Builder toDtoBuilder = MethodSpec.methodBuilder((String)"toDto").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)dtoClass).addParameter((TypeName)entityClass, "entity", new Modifier[0]);
        mappingAnnotations.forEach(arg_0 -> ((MethodSpec.Builder)toDtoBuilder).addAnnotation(arg_0));
        TypeSpec mapperClass = TypeSpec.classBuilder((String)mapperName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(this.generatedAnnotation()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"Mapper", (String[])new String[0])).addMember("componentModel", "$S", new Object[]{"cdi"}).build()).superclass((TypeName)superType).addMethod(toEntityBuilder.build()).addMethod(toDtoBuilder.build()).build();
        JavaFile.builder((String)(basePackage + ".mapper"), (TypeSpec)mapperClass).indent("    ").build().writeTo(this.filer);
    }

    private void generateDTO(TypeElement entity, String dtoName, List<String> ignore) throws IOException, ClassNotFoundException {
        String basePackage = this.elementUtils.getPackageOf(entity).getQualifiedName().toString();
        ClassName dtoClass = ClassName.get((String)(basePackage + ".dto"), (String)dtoName, (String[])new String[0]);
        ClassName baseDtoClass = ClassName.bestGuess((String)DEV_HYPERAPI_RUNTIME_CORE_ENTITY_DTO);
        TypeSpec.Builder dtoBuilder = TypeSpec.classBuilder((ClassName)dtoClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)baseDtoClass).addAnnotation(this.generatedAnnotation()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"com.fasterxml.jackson.annotation", (String)"JsonInclude", (String[])new String[0])).addMember("value", "$T.Include.NON_NULL", new Object[]{ClassName.get((String)"com.fasterxml.jackson.annotation", (String)"JsonInclude", (String[])new String[0])}).build());
        ArrayList<Element> allFields = new ArrayList<Element>();
        for (Element element : entity.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || ignore.contains(element.getSimpleName().toString())) continue;
            String fieldName = element.getSimpleName().toString();
            TypeMirror fieldType = element.asType();
            TypeName fieldTypeName = TypeName.get((TypeMirror)fieldType);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)fieldTypeName, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"com.fasterxml.jackson.annotation", (String)"JsonProperty", (String[])new String[0])).addMember("value", "$S", new Object[]{fieldName}).build());
            if (PropertyGenerator.isCollectionType(fieldType)) {
                fieldBuilder.initializer("new $T<>()", new Object[]{HyperApiProcessor.getCollectionImplType(fieldType)});
            }
            dtoBuilder.addField(fieldBuilder.build());
            allFields.add(element);
            PropertyGenerator.addPropertyMethods(dtoBuilder, element);
        }
        if (allFields.isEmpty()) {
            String wanrMessage = "%s : The class doesn't contain any fields to generate DTO for. Ensure it has fields annotated with @HyperResource or not ignored by mapping.";
            this.warn(entity, wanrMessage, entity.getQualifiedName().toString());
        }
        this.addCommonMethods(dtoBuilder, allFields, dtoName, entity.getSimpleName().toString());
        JavaFile.builder((String)dtoClass.packageName(), (TypeSpec)dtoBuilder.build()).indent("    ").build().writeTo(this.filer);
    }

    private static TypeName getCollectionImplType(TypeMirror collectionType) {
        if (collectionType.toString().startsWith("java.util.List")) {
            return ClassName.get(ArrayList.class);
        }
        if (collectionType.toString().startsWith("java.util.Set")) {
            return ClassName.get(HashSet.class);
        }
        if (collectionType.toString().startsWith("java.util.Map")) {
            return ClassName.get(HashMap.class);
        }
        return ClassName.get(Object.class);
    }

    private void addCommonMethods(TypeSpec.Builder builder, List<Element> fields, String className, String originalName) throws ClassNotFoundException {
        ClassName objectsClass = ClassName.get((String)"java.util", (String)"Objects", (String[])new String[0]);
        List<String> baseDtoFields = this.getBaseDtoFields();
        ArrayList allFieldNames = new ArrayList();
        fields.stream().map(f -> f.getSimpleName().toString()).forEach(allFieldNames::add);
        this.generateCommonMethods(builder, fields, className, objectsClass);
    }

    private List<String> getBaseDtoFields() throws ClassNotFoundException {
        ArrayList<String> fieldNames = new ArrayList<String>();
        TypeElement baseDtoType = this.elementUtils.getTypeElement(DEV_HYPERAPI_RUNTIME_CORE_ENTITY_DTO);
        if (baseDtoType != null) {
            for (Element element : this.elementUtils.getAllMembers(baseDtoType)) {
                if (element.getKind() != ElementKind.FIELD) continue;
                fieldNames.add(element.getSimpleName().toString());
            }
        } else {
            throw new ClassNotFoundException("BaseDTO class not found in classpath");
        }
        return fieldNames;
    }

    private void generateCommonMethods(TypeSpec.Builder builder, List<Element> fields, String className, ClassName objectsClass) {
        if (!fields.isEmpty()) {
            StringBuilder toStringFormat = new StringBuilder(className + " [");
            ArrayList<String> toStringArgs = new ArrayList<String>();
            for (int i = 0; i < fields.size(); ++i) {
                String fieldName = fields.get(i).getSimpleName().toString();
                if (i > 0) {
                    toStringFormat.append(", ");
                }
                toStringFormat.append(fieldName).append("=%s");
                toStringArgs.add(fieldName);
            }
            toStringFormat.append("]");
            String formatArgs = toStringArgs.stream().map(Object::toString).collect(Collectors.joining(", "));
            MethodSpec toString = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addAnnotation(Override.class).addStatement("return String.format($S, $L)", new Object[]{toStringFormat.toString(), formatArgs}).build();
            builder.addMethod(toString);
        }
        if (!fields.isEmpty()) {
            ClassName dtoClassName = ClassName.bestGuess((String)className);
            MethodSpec.Builder equalsBuilder = MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addAnnotation(Override.class).addParameter(Object.class, "o", new Modifier[0]).beginControlFlow("if (this == o)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().beginControlFlow("if (o == null || getClass() != o.getClass())", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().addStatement("$T that = ($T) o", new Object[]{dtoClassName, dtoClassName});
            CodeBlock.Builder comparisonBuilder = CodeBlock.builder();
            for (Element field : fields) {
                String fieldName = field.getSimpleName().toString();
                if (comparisonBuilder.isEmpty()) {
                    comparisonBuilder.add("$T.equals(this.$L, that.$L)", new Object[]{objectsClass, fieldName, fieldName});
                    continue;
                }
                comparisonBuilder.add(" &&\n    $T.equals(this.$L, that.$L)", new Object[]{objectsClass, fieldName, fieldName});
            }
            equalsBuilder.addStatement("return $L", new Object[]{comparisonBuilder.build()});
            builder.addMethod(equalsBuilder.build());
        }
        if (!fields.isEmpty()) {
            String hashFields = fields.stream().map(f -> f.getSimpleName().toString()).collect(Collectors.joining(", "));
            MethodSpec hashCode = MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addAnnotation(Override.class).addStatement("return $T.hash($L)", new Object[]{objectsClass, hashFields}).build();
            builder.addMethod(hashCode);
        }
    }

    private MethodSpec generateCreateOverride(ClassName dtoClass, ClassName entityEventClass, boolean customEmitter) {
        String strCustomEmitter = customEmitter ? "emitter.emit" : "fireEvent";
        return MethodSpec.methodBuilder((String)"create").addAnnotation(Override.class).addAnnotation(ClassName.get((String)"jakarta.transaction", (String)"Transactional", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)dtoClass).addParameter((TypeName)dtoClass, "dto", new Modifier[0]).addStatement("$T result = super.create(dto)", new Object[]{dtoClass}).addStatement(strCustomEmitter + "($T.Type.CREATE, mapper.toEntity(result))", new Object[]{entityEventClass}).addStatement("return result", new Object[0]).build();
    }

    private MethodSpec generateUpdateOverride(ClassName dtoClass, ClassName entityEventClass, boolean customEmitter) {
        String strCustomEmitter = customEmitter ? "emitter.emit" : "fireEvent";
        return MethodSpec.methodBuilder((String)"update").addAnnotation(Override.class).addAnnotation(ClassName.get((String)"jakarta.transaction", (String)"Transactional", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)dtoClass).addParameter((TypeName)dtoClass, "dto", new Modifier[0]).addStatement("$T result = super.update(dto)", new Object[]{dtoClass}).addStatement(strCustomEmitter + "($T.Type.UPDATE, mapper.toEntity(result))", new Object[]{entityEventClass}).addStatement("return result", new Object[0]).build();
    }

    private MethodSpec generateDeleteOverride(ClassName entityEventClass, boolean customEmitter) {
        String strCustomEmitter = customEmitter ? "emitter.emit" : "fireEvent";
        return MethodSpec.methodBuilder((String)"delete").addAnnotation(Override.class).addAnnotation(ClassName.get((String)"jakarta.transaction", (String)"Transactional", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Long.class), (String)"id", (Modifier[])new Modifier[0]).build()).addStatement("super.delete(id)", new Object[0]).addStatement(strCustomEmitter + "($T.Type.DELETE, null)", new Object[]{entityEventClass}).build();
    }

    private MethodSpec generatePatchOverride(ClassName dtoClass, ClassName entityEventClass, boolean customEmitter) {
        String strCustomEmitter = customEmitter ? "emitter.emit" : "fireEvent";
        return MethodSpec.methodBuilder((String)"patch").addAnnotation(Override.class).addAnnotation(ClassName.get((String)"jakarta.transaction", (String)"Transactional", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)dtoClass).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Long.class), (String)"id", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)"jakarta.json", (String)"JsonObject", (String[])new String[0]), (String)"patchJson", (Modifier[])new Modifier[0]).build()).addStatement("$T result = super.patch(id, patchJson)", new Object[]{dtoClass}).addStatement(strCustomEmitter + "($T.Type.UPDATE, mapper.toEntity(result))", new Object[]{entityEventClass}).addStatement("return result", new Object[0]).build();
    }

    private void generateService(TypeElement entity, String dtoName, HyperResource hyperResource) throws IOException, ClassNotFoundException {
        MethodSpec method;
        String entityName = entity.getSimpleName().toString();
        String basePackage = this.elementUtils.getPackageOf(entity).getQualifiedName().toString();
        String serviceName = entityName + "Service";
        ClassName dtoClass = ClassName.get((String)(basePackage + ".dto"), (String)dtoName, (String[])new String[0]);
        ClassName entityClass = ClassName.get((String)basePackage, (String)entityName, (String[])new String[0]);
        ClassName mapperClass = ClassName.get((String)(basePackage + ".mapper"), (String)(entityName + "Mapper"), (String[])new String[0]);
        Events events = hyperResource.events();
        boolean fireOnCreate = events.onCreate();
        boolean fireOnUpdate = events.onUpdate();
        boolean fireOnDelete = events.onDelete();
        boolean fireOnPatch = events.onDelete();
        ParameterizedTypeName superType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"com.eorghe.hyperapi.service", (String)"BaseEntityService", (String[])new String[0]), (TypeName[])new TypeName[]{entityClass, dtoClass, mapperClass});
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.class)", new Object[]{dtoClass});
        TypeSpec.Builder serviceClass = TypeSpec.classBuilder((String)serviceName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.generatedAnnotation()).addAnnotation(ClassName.get((String)"jakarta.enterprise.context", (String)"ApplicationScoped", (String[])new String[0])).superclass((TypeName)superType);
        MethodSpec repoGetter = this.generateInjectRepository(entity, basePackage, entityName, serviceClass, entityClass, hyperResource);
        serviceClass.addMethod(repoGetter);
        Optional<TypeMirror> emitterMirror = this.getEmitterTypeMirror(entity);
        if (fireOnCreate) {
            method = this.generateCreateOverride(dtoClass, ClassName.get((String)"com.eorghe.hyperapi.events", (String)"EntityEvent", (String[])new String[0]), emitterMirror.isPresent());
            serviceClass.addMethod(method);
        }
        if (fireOnUpdate) {
            method = this.generateUpdateOverride(dtoClass, ClassName.get((String)"com.eorghe.hyperapi.events", (String)"EntityEvent", (String[])new String[0]), emitterMirror.isPresent());
            serviceClass.addMethod(method);
        }
        if (fireOnDelete) {
            method = this.generateDeleteOverride(ClassName.get((String)"com.eorghe.hyperapi.events", (String)"EntityEvent", (String[])new String[0]), emitterMirror.isPresent());
            serviceClass.addMethod(method);
        }
        if (fireOnPatch) {
            method = this.generatePatchOverride(dtoClass, ClassName.get((String)"com.eorghe.hyperapi.events", (String)"EntityEvent", (String[])new String[0]), emitterMirror.isPresent());
            serviceClass.addMethod(method);
        }
        emitterMirror.ifPresent(typeMirror -> serviceClass.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((TypeMirror)typeMirror), (String)"emitter", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(ClassName.get((String)"jakarta.inject", (String)"Inject", (String[])new String[0])).build()));
        serviceClass.addMethod(constructor.build());
        JavaFile.builder((String)(basePackage + ".service"), (TypeSpec)serviceClass.build()).indent("    ").build().writeTo(this.filer);
    }

    private MethodSpec generateInjectRepository(TypeElement entity, String basePackage, String entityName, TypeSpec.Builder serviceClass, ClassName entityClass, HyperResource hyperResource) {
        ClassName repositoryClass = ClassName.get((String)(basePackage + "." + hyperResource.repositoryPackage()), (String)(entityName + "Repository"), (String[])new String[0]);
        serviceClass.addField(FieldSpec.builder((TypeName)repositoryClass, (String)"repository", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(ClassName.get((String)"jakarta.inject", (String)"Inject", (String[])new String[0])).build());
        ParameterizedTypeName repoType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"io.quarkus.hibernate.orm.panache", (String)"PanacheRepositoryBase", (String[])new String[0]), (TypeName[])new TypeName[]{entityClass, ClassName.get((String)"java.lang", (String)"Long", (String[])new String[0])});
        MethodSpec repoGetter = MethodSpec.methodBuilder((String)"getRepository").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)repoType).addStatement("return repository", new Object[0]).build();
        return repoGetter;
    }

    private Optional<TypeMirror> getEmitterTypeMirror(TypeElement element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals("annotations.processor.com.eorghe.runtime.core.HyperResource")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals("events")) continue;
                AnnotationMirror events = (AnnotationMirror)entry.getValue().getValue();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ev : events.getElementValues().entrySet()) {
                    if (!ev.getKey().getSimpleName().contentEquals("emitter")) continue;
                    return Optional.of((TypeMirror)ev.getValue().getValue());
                }
            }
        }
        return Optional.empty();
    }

    private void generateController(TypeElement entity, String dtoName, HyperResource hyperResource) throws IOException {
        String entityName = entity.getSimpleName().toString();
        String basePackage = this.elementUtils.getPackageOf(entity).getQualifiedName().toString();
        String controllerName = entityName + "HyperResource";
        ClassName dtoClass = ClassName.get((String)(basePackage + ".dto"), (String)dtoName, (String[])new String[0]);
        ClassName mapperClass = ClassName.get((String)(basePackage + ".mapper"), (String)(entityName + "Mapper"), (String[])new String[0]);
        ClassName serviceClass = ClassName.get((String)(basePackage + ".service"), (String)(entityName + "Service"), (String[])new String[0]);
        ClassName entityClass = ClassName.get((String)basePackage, (String)entityName, (String[])new String[0]);
        ParameterizedTypeName superType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"com.eorghe.hyperapi.controller", (String)"RestController", (String[])new String[0]), (TypeName[])new TypeName[]{dtoClass, mapperClass, entityClass});
        Object path = hyperResource.path().isBlank() ? "/api/" + entityName.toLowerCase() : hyperResource.path();
        Scope scope = hyperResource.scope();
        TypeSpec.Builder ctrl = TypeSpec.classBuilder((String)controllerName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.generatedAnnotation()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"jakarta.ws.rs", (String)"Path", (String[])new String[0])).addMember("value", "$S", new Object[]{path}).build()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)scope.getScopeClass())).build()).superclass((TypeName)superType).addField(FieldSpec.builder((TypeName)serviceClass, (String)"service", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(ClassName.get((String)"jakarta.inject", (String)"Inject", (String[])new String[0])).build()).addMethod(MethodSpec.methodBuilder((String)"getService").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)"com.eorghe.hyperapi.service", (String)"BaseEntityService", (String[])new String[0]), (TypeName[])new TypeName[]{entityClass, dtoClass, mapperClass})).addStatement("return service", new Object[0]).build());
        Optional<HttpMethod> isGetMethodDisabled = Arrays.stream(hyperResource.disabledFor()).filter(r -> r == HttpMethod.GET).findFirst();
        if (hyperResource.pageable() != null && isGetMethodDisabled.isEmpty()) {
            int defaultLimit = hyperResource.pageable().limit();
            int maxLimit = hyperResource.pageable().maxLimit();
            MethodSpec getAll = MethodSpec.methodBuilder((String)"getAll").addAnnotation(GET.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{dtoClass})).addParameter(ParameterSpec.builder((TypeName)TypeName.INT, (String)"offset", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(QueryParam.class).addMember("value", "$S", new Object[]{"offset"}).build()).addAnnotation(AnnotationSpec.builder(DefaultValue.class).addMember("value", "$S", new Object[]{"0"}).build()).build()).addParameter(ParameterSpec.builder((TypeName)TypeName.INT, (String)"limit", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(QueryParam.class).addMember("value", "$S", new Object[]{"limit"}).build()).addAnnotation(AnnotationSpec.builder(DefaultValue.class).addMember("value", "$S", new Object[]{String.valueOf(defaultLimit)}).build()).build()).addStatement("return getService().findAll(offset, Math.min(limit, $L))", new Object[]{maxLimit}).build();
            ctrl.addMethod(getAll);
        }
        if (hyperResource.disabledFor().length > 0) {
            Set<String> disabledMethods = Arrays.stream(hyperResource.disabledFor()).map(Enum::name).collect(Collectors.toSet());
            disabledMethods.forEach(method -> {
                if (method.equals("DELETE")) {
                    ctrl.addMethod(this.generateDisabledDeleteMethod(dtoClass));
                }
                if (method.equals("GET")) {
                    ctrl.addMethod(this.generateDisabledGetByIdMethod(dtoClass));
                    ctrl.addMethod(this.generateDisabledGetAllMethod(dtoClass));
                }
                if (method.equals("POST")) {
                    ctrl.addMethod(this.generateDisabledPostMethod(dtoClass));
                }
                if (method.equals("PUT")) {
                    ctrl.addMethod(this.generateDisabledPutMethod(dtoClass));
                }
                if (method.equals("PATCH")) {
                    ctrl.addMethod(this.generateDisabledPatchMethod());
                }
            });
        }
        JavaFile.builder((String)(basePackage + ".controller"), (TypeSpec)ctrl.build()).indent("    ").build().writeTo(this.filer);
    }

    private MethodSpec generateDisabledDeleteMethod(ClassName dtoClass) {
        return MethodSpec.methodBuilder((String)"delete").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(Object.class, (String)"id", (Modifier[])new Modifier[0]).build()).returns((TypeName)ClassName.get((String)"jakarta.ws.rs.core", (String)"Response", (String[])new String[0])).addStatement("throw new $T($S)", new Object[]{ClassName.get((String)"jakarta.ws.rs", (String)"NotFoundException", (String[])new String[0]), "DELETE method is disabled for this resource"}).build();
    }

    private MethodSpec generateDisabledGetAllMethod(ClassName dtoClass) {
        return MethodSpec.methodBuilder((String)"getAll").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{dtoClass})).addParameter(ParameterSpec.builder((TypeName)TypeName.INT, (String)"offset", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)TypeName.INT, (String)"limit", (Modifier[])new Modifier[0]).build()).addStatement("throw new $T($S)", new Object[]{ClassName.get((String)"jakarta.ws.rs", (String)"NotFoundException", (String[])new String[0]), "Get All method is disabled for this resource"}).build();
    }

    private MethodSpec generateDisabledGetByIdMethod(ClassName dtoClass) {
        return MethodSpec.methodBuilder((String)"getById").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"jakarta.ws.rs.core", (String)"Response", (String[])new String[0])).addParameter(ParameterSpec.builder(Long.class, (String)"id", (Modifier[])new Modifier[0]).build()).addStatement("throw new $T($S)", new Object[]{ClassName.get((String)"jakarta.ws.rs", (String)"NotFoundException", (String[])new String[0]), "Get By Id method is disabled for this resource"}).build();
    }

    private MethodSpec generateDisabledPostMethod(ClassName dtoClass) {
        return MethodSpec.methodBuilder((String)"create").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"jakarta.ws.rs.core", (String)"Response", (String[])new String[0])).addParameter((TypeName)dtoClass, "dto", new Modifier[0]).addStatement("throw new $T($S)", new Object[]{ClassName.get((String)"jakarta.ws.rs", (String)"NotFoundException", (String[])new String[0]), "POST method is disabled for this resource"}).build();
    }

    private MethodSpec generateDisabledPutMethod(ClassName dtoClass) {
        return MethodSpec.methodBuilder((String)"update").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"jakarta.ws.rs.core", (String)"Response", (String[])new String[0])).addParameter(ParameterSpec.builder(Object.class, (String)"id", (Modifier[])new Modifier[0]).build()).addParameter((TypeName)dtoClass, "dto", new Modifier[0]).addStatement("throw new $T($S)", new Object[]{ClassName.get((String)"jakarta.ws.rs", (String)"NotFoundException", (String[])new String[0]), "PUT method is disabled for this resource"}).build();
    }

    private MethodSpec generateDisabledPatchMethod() {
        return MethodSpec.methodBuilder((String)"patch").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"jakarta.ws.rs.core", (String)"Response", (String[])new String[0])).addParameter(ParameterSpec.builder(Object.class, (String)"id", (Modifier[])new Modifier[0]).build()).addParameter((TypeName)ClassName.get((String)"jakarta.json", (String)"JsonObject", (String[])new String[0]), "patchJson", new Modifier[0]).addStatement("throw new $T($S)", new Object[]{ClassName.get((String)"jakarta.ws.rs", (String)"NotFoundException", (String[])new String[0]), "PATH method is disabled for this resource"}).build();
    }

    private void error(Element e, String msg) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    private void error(Element e, String msg, String ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    private void info(Element e, String msg) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg, e);
    }

    private void warn(Element e, String msg) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg, e);
    }

    private void warn(Element e, String msg, String ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), e);
    }

    private String sanitizeDtoName(String entityName, String rawDto) {
        if (rawDto == null || rawDto.isBlank()) {
            return entityName + "DTO";
        }
        String cleaned = rawDto.replaceAll("(?i)_?dto$", "").trim();
        return cleaned + "DTO";
    }

    private AnnotationSpec generatedAnnotation() {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"com.eorghe.hyperapi.processor.HyperResourceProcessor"}).addMember("date", "$S", new Object[]{OffsetDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)}).addMember("comments", "$S", new Object[]{String.format("Source version: %s\nCompiler: %s %s\nBuild environment: %s %s (%s)\nProject: %s\nLicense: Apache 2.0", Runtime.version(), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), "HyperAPI Quarkus Extension")}).build();
    }
}

