/*
 * Decompiled with CFR 0.152.
 */
package com.eorghe.hyperapi.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class PropertyGenerator {
    private static final List<String> JAVA_PACKAGES = Arrays.asList("java.", "javax.", "jakarta.", "android.", "com.sun.", "org.w3c.", "org.xml.");

    public static void addBuilderSupport(TypeSpec.Builder classBuilder, List<Element> fields, String className) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(className + "Builder")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        for (Element field : fields) {
            String fieldName = field.getSimpleName().toString();
            TypeName fieldType = TypeName.get((TypeMirror)field.asType());
            builder.addField(FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        }
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        builder.addMethod(constructor);
        MethodSpec builderMethod = MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.bestGuess((String)(className + "Builder"))).addStatement("return new $T()", new Object[]{ClassName.bestGuess((String)(className + "Builder"))}).build();
        classBuilder.addMethod(builderMethod);
        for (Element field : fields) {
            String fieldName = field.getSimpleName().toString();
            TypeName fieldType = TypeName.get((TypeMirror)field.asType());
            MethodSpec withMethod = MethodSpec.methodBuilder((String)("with" + PropertyGenerator.capitalize(fieldName))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.bestGuess((String)(className + "Builder"))).addParameter(fieldType, fieldName, new Modifier[0]).addStatement("this.$L = $L", new Object[]{fieldName, fieldName}).addStatement("return this", new Object[0]).build();
            builder.addMethod(withMethod);
        }
        CodeBlock.Builder codeBuilder = CodeBlock.builder().addStatement("$T dto = new $T()", new Object[]{ClassName.bestGuess((String)className), ClassName.bestGuess((String)className)});
        fields.forEach(f -> codeBuilder.addStatement("dto.$L = this.$L", new Object[]{f.getSimpleName(), f.getSimpleName()}));
        MethodSpec buildMethod = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.bestGuess((String)className)).addCode(codeBuilder.build()).addStatement("return dto", new Object[0]).build();
        builder.addMethod(buildMethod);
        classBuilder.addType(builder.build());
    }

    public static void addPropertyMethods(TypeSpec.Builder classBuilder, Element field) {
        String fieldName = field.getSimpleName().toString();
        TypeMirror fieldType = field.asType();
        TypeName fieldTypeName = TypeName.get((TypeMirror)fieldType);
        MethodSpec getter = PropertyGenerator.generateGetter(fieldName, fieldTypeName, field.getModifiers());
        classBuilder.addMethod(getter);
        if (!field.getModifiers().contains((Object)Modifier.FINAL)) {
            MethodSpec setter = PropertyGenerator.generateSetter(fieldName, fieldTypeName, field.getModifiers());
            classBuilder.addMethod(setter);
        }
        if (PropertyGenerator.isCollectionType(fieldType)) {
            PropertyGenerator.addCollectionMethods(classBuilder, field);
        }
    }

    private static MethodSpec generateGetter(String fieldName, TypeName fieldType, Set<Modifier> modifiers) {
        String getterName = "get" + PropertyGenerator.capitalize(fieldName);
        if (fieldType.equals((Object)TypeName.BOOLEAN)) {
            getterName = "is" + PropertyGenerator.capitalize(fieldName);
        }
        return MethodSpec.methodBuilder((String)getterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(fieldType).addStatement("return this.$L", new Object[]{fieldName}).build();
    }

    private static MethodSpec generateSetter(String fieldName, TypeName fieldType, Set<Modifier> modifiers) {
        return MethodSpec.methodBuilder((String)("set" + PropertyGenerator.capitalize(fieldName))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(fieldType, fieldName, new Modifier[0]).addStatement("this.$L = $L", new Object[]{fieldName, fieldName}).build();
    }

    public static boolean isCustomObject(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        String typeName = type.toString();
        if (type.getKind().isPrimitive() || typeName.endsWith("[]")) {
            return false;
        }
        for (String pkg : JAVA_PACKAGES) {
            if (!typeName.startsWith(pkg)) continue;
            return false;
        }
        return ((DeclaredType)type).asElement().getKind() != ElementKind.ENUM;
    }

    static boolean isCollectionType(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        String typeName = type.toString();
        return typeName.startsWith("java.util.List") || typeName.startsWith("java.util.Set") || typeName.startsWith("java.util.Collection") || typeName.startsWith("java.util.Map");
    }

    private static void addCollectionMethods(TypeSpec.Builder classBuilder, Element field) {
        String fieldName = field.getSimpleName().toString();
        TypeMirror fieldType = field.asType();
        if (fieldType.toString().startsWith("java.util.Map")) {
            MethodSpec putter = MethodSpec.methodBuilder((String)("put" + PropertyGenerator.capitalize(fieldName) + "Entry")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(PropertyGenerator.getMapKeyType(fieldType), "key", new Modifier[0]).addParameter(PropertyGenerator.getMapValueType(fieldType), "value", new Modifier[0]).addStatement("this.$L.put(key, value)", new Object[]{fieldName}).build();
            classBuilder.addMethod(putter);
        } else {
            MethodSpec adder = MethodSpec.methodBuilder((String)("add" + PropertyGenerator.capitalize(fieldName) + "Item")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(PropertyGenerator.getCollectionElementType(fieldType), "item", new Modifier[0]).addStatement("this.$L.add(item)", new Object[]{fieldName}).build();
            classBuilder.addMethod(adder);
        }
        MethodSpec clearer = MethodSpec.methodBuilder((String)("clear" + PropertyGenerator.capitalize(fieldName))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.$L.clear()", new Object[]{fieldName}).build();
        classBuilder.addMethod(clearer);
    }

    private static TypeName getCollectionElementType(TypeMirror collectionType) {
        List<? extends TypeMirror> typeArgs;
        if (collectionType instanceof DeclaredType && !(typeArgs = ((DeclaredType)collectionType).getTypeArguments()).isEmpty()) {
            return TypeName.get((TypeMirror)typeArgs.get(0));
        }
        return TypeName.get(Object.class);
    }

    private static TypeName getMapKeyType(TypeMirror mapType) {
        List<? extends TypeMirror> typeArgs;
        if (mapType instanceof DeclaredType && (typeArgs = ((DeclaredType)mapType).getTypeArguments()).size() > 0) {
            return TypeName.get((TypeMirror)typeArgs.get(0));
        }
        return TypeName.get(Object.class);
    }

    private static TypeName getMapValueType(TypeMirror mapType) {
        List<? extends TypeMirror> typeArgs;
        if (mapType instanceof DeclaredType && (typeArgs = ((DeclaredType)mapType).getTypeArguments()).size() > 1) {
            return TypeName.get((TypeMirror)typeArgs.get(1));
        }
        return TypeName.get(Object.class);
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

