/*
 * Decompiled with CFR 0.152.
 */
package com.eorghe.hyperapi.registry;

import com.eorghe.hyperapi.processor.annotations.HyperResource;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.persistence.Entity;
import jakarta.ws.rs.NotFoundException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;

@ApplicationScoped
public class EntityRegistry {
    @ConfigProperty(name="hyperapi.scan-packages", defaultValue="")
    String configuredPackages;
    private Set<Class<?>> exposed;

    @PostConstruct
    void init() {
        ConfigurationBuilder cfg = new ConfigurationBuilder().addScanners(new Scanner[]{Scanners.TypesAnnotated});
        if (!this.configuredPackages.isBlank()) {
            cfg.forPackages((String[])Arrays.stream(this.configuredPackages.split(",")).map(String::trim).toArray(String[]::new));
        }
        Reflections reflections = new Reflections((Configuration)cfg);
        this.exposed = reflections.getTypesAnnotatedWith(Entity.class).stream().filter(c -> c.isAnnotationPresent(HyperResource.class)).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Class<?>> all() {
        return this.exposed;
    }

    public Optional<Class<?>> bySimpleName(String simple) {
        return this.exposed.stream().filter(c -> c.getSimpleName().equalsIgnoreCase(simple)).findFirst();
    }

    public Class<?> resolve(String simple) {
        return this.bySimpleName(simple).orElseThrow(() -> new NotFoundException("Entity not found: " + simple));
    }
}

