/*
 * Decompiled with CFR 0.152.
 */
package com.eorghe.hyperapi.service;

import com.eorghe.hyperapi.dto.HyperDto;
import com.eorghe.hyperapi.events.EntityEvent;
import com.eorghe.hyperapi.mapper.AbstractMapper;
import com.eorghe.hyperapi.model.HyperEntity;
import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonMergePatch;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.NotFoundException;
import java.util.List;

public abstract class BaseEntityService<ENTITY extends HyperEntity, DTO extends HyperDto, MAPPER extends AbstractMapper<DTO, ENTITY>> {
    private final Class<DTO> dtoClass;
    @Inject
    protected MAPPER mapper;
    @Inject
    Jsonb jsonb;
    @Inject
    Event<EntityEvent<ENTITY>> event;

    protected BaseEntityService(Class<DTO> dtoClass) {
        this.dtoClass = dtoClass;
    }

    protected abstract PanacheRepositoryBase<ENTITY, Long> getRepository();

    public List<DTO> findAll(int offset, int limit) {
        return ((AbstractMapper)this.mapper).toList(this.getRepository().findAll().page(offset / limit, limit).list());
    }

    public DTO findById(Long id) {
        HyperEntity entity = (HyperEntity)((Object)this.getRepository().findById((Object)id));
        return (DTO)(entity != null ? (HyperDto)((AbstractMapper)this.mapper).toDto((HyperEntity)entity) : null);
    }

    @Transactional
    public DTO create(DTO dto) {
        Object entity = ((AbstractMapper)this.mapper).toEntity(dto);
        this.getRepository().persist(entity);
        return (DTO)((HyperDto)((AbstractMapper)this.mapper).toDto(entity));
    }

    @Transactional
    public DTO update(DTO dto) {
        Object entity = ((AbstractMapper)this.mapper).toEntity(dto);
        HyperEntity merged = (HyperEntity)((Object)this.getRepository().getEntityManager().merge(entity));
        return (DTO)((HyperDto)((AbstractMapper)this.mapper).toDto((HyperEntity)merged));
    }

    @Transactional
    public void delete(Long id) {
        this.getRepository().deleteById((Object)id);
    }

    @Transactional
    public DTO patch(Long id, JsonObject patchJson) {
        DTO existingDto = this.findById(id);
        if (existingDto == null) {
            throw new NotFoundException("Entity not found");
        }
        JsonObject existingJson = (JsonObject)this.jsonb.fromJson(this.jsonb.toJson(existingDto), JsonObject.class);
        JsonMergePatch mergePatch = Json.createMergePatch((JsonValue)patchJson);
        JsonValue patchedValue = mergePatch.apply((JsonValue)existingJson);
        JsonObject mergedJson = patchedValue.asJsonObject();
        DTO patchedDto = this.jsonToDto(mergedJson);
        ((HyperDto)patchedDto).setCreatedOn(((HyperDto)existingDto).getCreatedOn());
        ((HyperDto)patchedDto).setCreatedBy(((HyperDto)existingDto).getCreatedBy());
        ((HyperDto)patchedDto).setId(id);
        return this.update(patchedDto);
    }

    private DTO jsonToDto(JsonObject json) {
        return (DTO)((HyperDto)this.jsonb.fromJson(json.toString(), this.dtoClass));
    }

    protected void fireEvent(EntityEvent.Type type, ENTITY entity) {
        if (this.event != null && entity != null) {
            this.event.fire(new EntityEvent<ENTITY>(type, entity));
        }
    }
}

