/*
 * Decompiled with CFR 0.152.
 */
package com.erlitech.ejava.utils;

import com.erlitech.ejava.utils.XLoggerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XPropertyUtil {
    private static final Logger LOGGER = XLoggerUtil.getLogger(XPropertyUtil.class.getName());
    private static final Map<String, Properties> PROPERTIES = new HashMap<String, Properties>();

    private static void loadPropertiesFile(String fileName) {
        LOGGER.info("properties\u6587\u4ef6: " + fileName + "\uff0c\u5f00\u59cb\u52a0\u8f7d...");
        ClassLoader classLoader = XLoggerUtil.class.getClassLoader();
        InputStream inputStream = null != classLoader ? classLoader.getResourceAsStream(fileName + ".properties") : ClassLoader.getSystemResourceAsStream(fileName + ".properties");
        if (null == inputStream) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            PROPERTIES.put(fileName, properties);
            LOGGER.info("properties\u6587\u4ef6: " + fileName + "\uff0c\u52a0\u8f7d\u5b8c\u6210");
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "properties\u6587\u4ef6: " + fileName + ".properties\uff0cIO\u9519\u8bef\u3002" + e);
        }
    }

    public static String getProperty(String key, String fileName) {
        if (!PROPERTIES.containsKey(fileName)) {
            XPropertyUtil.loadPropertiesFile(fileName);
        }
        if (!PROPERTIES.containsKey(fileName)) {
            LOGGER.log(Level.SEVERE, "properties\u6587\u4ef6: " + fileName + ".properties \u4e0d\u5b58\u5728");
            return null;
        }
        Properties properties = PROPERTIES.get(fileName);
        String value = properties.getProperty(key);
        try {
            value = new String(value.getBytes("iso-8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return value;
    }
}

