/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Checkpointer;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.NotLeaderException;
import com.eventstore.dbclient.Position;
import com.eventstore.dbclient.ResolvedEvent;
import com.eventstore.dbclient.Subscription;
import com.eventstore.dbclient.SubscriptionListener;
import com.eventstore.dbclient.proto.shared.Shared;
import com.eventstore.dbclient.proto.streams.StreamsGrpc;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import javax.validation.constraints.NotNull;

public abstract class AbstractRegularSubscription {
    protected static final StreamsOuterClass.ReadReq.Options.Builder defaultReadOptions = StreamsOuterClass.ReadReq.Options.newBuilder().setUuidOption(StreamsOuterClass.ReadReq.Options.UUIDOption.newBuilder().setStructured(Shared.Empty.getDefaultInstance()));
    protected static final StreamsOuterClass.ReadReq.Options.Builder defaultSubscribeOptions = defaultReadOptions.clone().setReadDirection(StreamsOuterClass.ReadReq.Options.ReadDirection.Forwards).setSubscription(StreamsOuterClass.ReadReq.Options.SubscriptionOptions.getDefaultInstance());
    protected Metadata metadata;
    protected SubscriptionListener listener;
    protected Checkpointer checkpointer = null;
    private final GrpcClient client;

    protected AbstractRegularSubscription(GrpcClient client, Metadata metadata) {
        this.client = client;
        this.metadata = metadata;
    }

    protected abstract StreamsOuterClass.ReadReq.Options.Builder createOptions();

    public CompletableFuture<Subscription> execute() {
        return this.client.run(channel -> {
            StreamsOuterClass.ReadReq readReq = StreamsOuterClass.ReadReq.newBuilder().setOptions(this.createOptions()).build();
            StreamsGrpc.StreamsStub client = (StreamsGrpc.StreamsStub)MetadataUtils.attachHeaders((AbstractStub)StreamsGrpc.newStub((Channel)channel), (Metadata)this.metadata);
            final CompletableFuture future = new CompletableFuture();
            ClientResponseObserver<StreamsOuterClass.ReadReq, StreamsOuterClass.ReadResp> observer = new ClientResponseObserver<StreamsOuterClass.ReadReq, StreamsOuterClass.ReadResp>(){
                private boolean _confirmed;
                private Subscription _subscription;
                private ClientCallStreamObserver _requestStream;

                public void beforeStart(ClientCallStreamObserver<StreamsOuterClass.ReadReq> requestStream) {
                    this._requestStream = requestStream;
                }

                public void onNext(@NotNull StreamsOuterClass.ReadResp readResp) {
                    if (!this._confirmed && readResp.hasConfirmation()) {
                        this._confirmed = true;
                        this._subscription = new Subscription((ClientCallStreamObserver<StreamsOuterClass.ReadReq>)this._requestStream, readResp.getConfirmation().getSubscriptionId(), AbstractRegularSubscription.this.checkpointer);
                        future.complete(this._subscription);
                        return;
                    }
                    if (!this._confirmed && readResp.hasEvent()) {
                        this.onError(new IllegalStateException("Unconfirmed subscription received event"));
                        return;
                    }
                    if (this._confirmed && readResp.hasCheckpoint()) {
                        Checkpointer checkpointer = this._subscription.getCheckpointer();
                        if (checkpointer == null) {
                            return;
                        }
                        StreamsOuterClass.ReadResp.Checkpoint checkpoint = readResp.getCheckpoint();
                        Position checkpointPos = new Position(checkpoint.getCommitPosition(), checkpoint.getPreparePosition());
                        checkpointer.onCheckpoint(this._subscription, checkpointPos);
                        return;
                    }
                    if (this._confirmed && !readResp.hasEvent()) {
                        this.onError(new IllegalStateException(String.format("Confirmed subscription %s received non-{event,checkpoint} variant", this._subscription.getSubscriptionId())));
                        return;
                    }
                    AbstractRegularSubscription.this.listener.onEvent(this._subscription, ResolvedEvent.fromWire(readResp.getEvent()));
                }

                public void onError(Throwable throwable) {
                    if (throwable instanceof StatusRuntimeException) {
                        StatusRuntimeException e = (StatusRuntimeException)throwable;
                        if (e.getStatus().getCode() == Status.Code.CANCELLED) {
                            AbstractRegularSubscription.this.listener.onCancelled(this._subscription);
                            return;
                        }
                        String leaderHost = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-host", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                        String leaderPort = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-port", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                        if (leaderHost != null && leaderPort != null) {
                            NotLeaderException reason = new NotLeaderException(leaderHost, Integer.valueOf(leaderPort));
                            AbstractRegularSubscription.this.listener.onError(this._subscription, reason);
                        }
                    }
                    AbstractRegularSubscription.this.listener.onError(this._subscription, throwable);
                }

                public void onCompleted() {
                }
            };
            client.read(readReq, (StreamObserver<StreamsOuterClass.ReadResp>)observer);
            return future;
        });
    }
}

