/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.CreateContinuousProjectionOptions;
import com.eventstore.dbclient.CreateOneTimeProjectionOptions;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.proto.projections.Projectionmanagement;
import com.eventstore.dbclient.proto.projections.ProjectionsGrpc;
import com.eventstore.dbclient.proto.shared.Shared;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

public class CreateProjection {
    private final GrpcClient client;
    private final boolean continuous;
    private final String projectionName;
    private final String query;
    private final boolean trackEmittedStreams;
    private final Metadata metadata;

    private CreateProjection(GrpcClient client, Metadata metadata, boolean continuous, String projectionName, String query, boolean trackEmittedStreams) {
        this.client = client;
        this.metadata = metadata;
        this.continuous = continuous;
        this.projectionName = projectionName;
        this.query = query;
        this.trackEmittedStreams = trackEmittedStreams;
    }

    static CreateProjection forContinuous(GrpcClient client, String projectionName, String query, CreateContinuousProjectionOptions options) {
        return new CreateProjection(client, options.getMetadata(), true, projectionName, query, options.isTrackingEmittedStreams());
    }

    static CreateProjection forOneTime(GrpcClient client, String projectionName, String query, CreateOneTimeProjectionOptions options) {
        return new CreateProjection(client, options.getMetadata(), false, projectionName, query, false);
    }

    public CompletableFuture execute() {
        return this.client.run(channel -> {
            Projectionmanagement.CreateReq.Options.Builder optionsBuilder = Projectionmanagement.CreateReq.Options.newBuilder().setQuery(this.query);
            this.setContinuousOrOneTime(optionsBuilder);
            Projectionmanagement.CreateReq request = Projectionmanagement.CreateReq.newBuilder().setOptions(optionsBuilder).build();
            Metadata headers = this.metadata;
            ProjectionsGrpc.ProjectionsStub client = (ProjectionsGrpc.ProjectionsStub)MetadataUtils.attachHeaders((AbstractStub)ProjectionsGrpc.newStub((Channel)channel), (Metadata)headers);
            CompletableFuture result = new CompletableFuture();
            client.create(request, (StreamObserver<Projectionmanagement.CreateResp>)GrpcUtils.convertSingleResponse(result));
            return result;
        });
    }

    private void setContinuousOrOneTime(Projectionmanagement.CreateReq.Options.Builder optionsBuilder) {
        if (this.continuous) {
            Projectionmanagement.CreateReq.Options.Continuous.Builder continuousBuilder = Projectionmanagement.CreateReq.Options.Continuous.newBuilder();
            continuousBuilder.setTrackEmittedStreams(this.trackEmittedStreams);
            continuousBuilder.setName(this.projectionName);
            optionsBuilder.setContinuous(continuousBuilder);
        } else {
            optionsBuilder.setOneTime(Shared.Empty.newBuilder());
        }
    }
}

