/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionBuilder;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.UserCredentials;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;

public class EventStoreDBClientBase {
    protected final GrpcClient client;
    protected final UserCredentials credentials;

    protected EventStoreDBClientBase(EventStoreDBClientSettings settings) {
        ConnectionBuilder builder = new ConnectionBuilder();
        this.credentials = settings.getDefaultCredentials() != null ? settings.getDefaultCredentials().toUserCredentials() : null;
        if (settings.isTls()) {
            try {
                SslContextBuilder sslContext = GrpcSslContexts.forClient();
                if (!settings.isTlsVerifyCert()) {
                    sslContext.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                builder.sslContext(sslContext.build());
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        }
        if (settings.isDnsDiscover()) {
            this.client = builder.createClusterConnectionUsingDns(settings.getHosts()[0], settings.getNodePreference());
            return;
        }
        if (settings.getHosts().length > 1) {
            this.client = builder.createClusterConnectionUsingSeeds(settings.getHosts(), settings.getNodePreference());
            return;
        }
        this.client = builder.createSingleNodeConnection(settings.getHosts()[0]);
    }

    public void shutdown() throws InterruptedException {
        this.client.shutdown();
    }
}

