/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionMetadata;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.ThrowingBiFunction;
import com.eventstore.dbclient.ThrowingFunction;
import com.eventstore.dbclient.UserCredentials;
import com.eventstore.dbclient.proto.projections.Projectionmanagement;
import com.eventstore.dbclient.proto.projections.ProjectionsGrpc;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class GetProjectionResult<TResult> {
    private final GrpcClient client;
    private final String projectionName;
    private final ConnectionMetadata metadata;
    private ThrowingBiFunction<JsonMapper, String, TResult, JsonProcessingException> deserializationStrategy;

    GetProjectionResult(GrpcClient client, UserCredentials credentials, String projectionName, Class<TResult> resultType) {
        this(client, credentials, projectionName);
        this.deserializationStrategy = (jsonMapper, json) -> jsonMapper.readValue(json, resultType);
    }

    GetProjectionResult(GrpcClient client, UserCredentials credentials, String projectionName, Function<TypeFactory, JavaType> javaTypeFunction) {
        this(client, credentials, projectionName);
        this.deserializationStrategy = (jsonMapper, json) -> jsonMapper.readValue(json, (JavaType)javaTypeFunction.apply(jsonMapper.getTypeFactory()));
    }

    private GetProjectionResult(GrpcClient client, UserCredentials credentials, String projectionName) {
        this.client = client;
        this.projectionName = projectionName;
        this.metadata = new ConnectionMetadata();
        if (credentials != null) {
            this.metadata.authenticated(credentials);
        }
    }

    public GetProjectionResult authenticated(UserCredentials credentials) {
        if (credentials == null) {
            return this;
        }
        this.metadata.authenticated(credentials);
        return this;
    }

    public CompletableFuture<TResult> execute() {
        return this.client.run(channel -> {
            Projectionmanagement.ResultReq.Options.Builder optionsBuilder = Projectionmanagement.ResultReq.Options.newBuilder().setName(this.projectionName);
            Projectionmanagement.ResultReq request = Projectionmanagement.ResultReq.newBuilder().setOptions(optionsBuilder).build();
            Metadata headers = this.metadata.build();
            ProjectionsGrpc.ProjectionsStub client = (ProjectionsGrpc.ProjectionsStub)MetadataUtils.attachHeaders((AbstractStub)ProjectionsGrpc.newStub((Channel)channel), (Metadata)headers);
            CompletableFuture result = new CompletableFuture();
            ThrowingFunction converter = source -> {
                String json = JsonFormat.printer().print((MessageOrBuilder)source.getResult());
                return this.deserializationStrategy.apply(new JsonMapper(), json);
            };
            client.result(request, (StreamObserver<Projectionmanagement.ResultResp>)GrpcUtils.convertSingleResponse(result, converter));
            return result;
        });
    }
}

