/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ClusterInfo;
import com.eventstore.dbclient.Timeouts;
import com.eventstore.dbclient.proto.gossip.GossipGrpc;
import com.eventstore.dbclient.proto.gossip.GossipOuterClass;
import com.eventstore.dbclient.proto.shared.Shared;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class GossipClient {
    private final ManagedChannel _channel;
    private final GossipGrpc.GossipStub _stub;
    private final Timeouts _timeouts;

    public GossipClient(String host, int port, Timeouts timeouts, SslContext sslContext) {
        this(((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).userAgent("Event Store Client (Java) v1.0.0-SNAPSHOT")).sslContext(sslContext).build(), timeouts);
    }

    public GossipClient(ManagedChannel channel, Timeouts timeouts) {
        this._channel = channel;
        this._timeouts = timeouts;
        this._stub = GossipGrpc.newStub((Channel)this._channel);
    }

    public void shutdown() throws InterruptedException {
        this._channel.shutdown().awaitTermination(this._timeouts.shutdownTimeout, this._timeouts.shutdownTimeoutUnit);
    }

    public CompletableFuture<ClusterInfo> read() {
        CompletableFuture<ClusterInfo> result = new CompletableFuture<ClusterInfo>();
        this._stub.read(Shared.Empty.getDefaultInstance(), (StreamObserver<GossipOuterClass.ClusterInfo>)this.convertSingleResponse(result, resp -> {
            ArrayList<ClusterInfo.Member> members = new ArrayList<ClusterInfo.Member>();
            for (GossipOuterClass.MemberInfo info : resp.getMembersList()) {
                UUID instanceId = null;
                if (info.hasInstanceId()) {
                    instanceId = info.getInstanceId().hasStructured() ? new UUID(info.getInstanceId().getStructured().getMostSignificantBits(), info.getInstanceId().getStructured().getLeastSignificantBits()) : UUID.fromString(info.getInstanceId().getString());
                }
                ClusterInfo.MemberState state = ClusterInfo.MemberState.fromWire(info.getState());
                ClusterInfo.Endpoint endpoint = new ClusterInfo.Endpoint(info.getHttpEndPoint().getAddress(), info.getHttpEndPoint().getPort());
                ClusterInfo.Member member = new ClusterInfo.Member(instanceId, info.getIsAlive(), state, endpoint);
                members.add(member);
            }
            return new ClusterInfo(members);
        }));
        return result;
    }

    private <ReqT, RespT, TargetT> ClientResponseObserver<ReqT, RespT> convertSingleResponse(final CompletableFuture<TargetT> dest, final Function<RespT, TargetT> converter) {
        return new ClientResponseObserver<ReqT, RespT>(){

            public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
            }

            public void onNext(RespT value) {
                try {
                    Object converted = converter.apply(value);
                    dest.complete(converted);
                }
                catch (Throwable e) {
                    dest.completeExceptionally(e);
                }
            }

            public void onError(Throwable t) {
                dest.completeExceptionally(t);
            }

            public void onCompleted() {
            }
        };
    }
}

