/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConsumerStrategy;
import com.eventstore.dbclient.PersistentSubscriptionSettings;

public class PersistentSubscriptionSettingsBuilder {
    private int checkpointAfterMs;
    private boolean extraStatistics;
    private boolean resolveLinks;
    private int historyBufferSize;
    private int liveBufferSize;
    private int maxCheckpointCount;
    private int maxRetryCount;
    private int maxSubscriberCount;
    private int messageTimeoutMs;
    private int minCheckpointCount;
    private int readBatchSize;
    private long revision;
    private ConsumerStrategy strategy;

    public PersistentSubscriptionSettingsBuilder() {
        this.checkpointAfterMs = 2000;
        this.resolveLinks = false;
        this.extraStatistics = false;
        this.revision = 0L;
        this.messageTimeoutMs = 30000;
        this.maxRetryCount = 10;
        this.minCheckpointCount = 10;
        this.maxCheckpointCount = 1000;
        this.maxSubscriberCount = 0;
        this.liveBufferSize = 500;
        this.readBatchSize = 20;
        this.historyBufferSize = 500;
        this.strategy = ConsumerStrategy.RoundRobin;
    }

    public PersistentSubscriptionSettingsBuilder(PersistentSubscriptionSettings settings) {
        this.checkpointAfterMs = settings.getCheckpointAfterMs();
        this.resolveLinks = settings.isResolveLinks();
        this.extraStatistics = settings.isExtraStatistics();
        this.revision = settings.getRevision();
        this.messageTimeoutMs = settings.getMessageTimeoutMs();
        this.maxRetryCount = settings.getMaxRetryCount();
        this.minCheckpointCount = settings.getMinCheckpointCount();
        this.maxCheckpointCount = settings.getMaxCheckpointCount();
        this.maxSubscriberCount = settings.getMaxSubscriberCount();
        this.liveBufferSize = settings.getLiveBufferSize();
        this.readBatchSize = settings.getReadBatchSize();
        this.historyBufferSize = settings.getHistoryBufferSize();
        this.strategy = settings.getStrategy();
    }

    public PersistentSubscriptionSettings build() {
        return new PersistentSubscriptionSettings(this.checkpointAfterMs, this.extraStatistics, this.resolveLinks, this.historyBufferSize, this.liveBufferSize, this.maxCheckpointCount, this.maxRetryCount, this.maxSubscriberCount, this.messageTimeoutMs, this.minCheckpointCount, this.readBatchSize, this.revision, this.strategy);
    }

    public PersistentSubscriptionSettingsBuilder enableLinkResolution() {
        return this.resolveLinks(true);
    }

    public PersistentSubscriptionSettingsBuilder disableLinkResolution() {
        return this.resolveLinks(false);
    }

    public PersistentSubscriptionSettingsBuilder resolveLinks(boolean value) {
        this.resolveLinks = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder enableExtraStatistics() {
        return this.extraStatistics(true);
    }

    public PersistentSubscriptionSettingsBuilder disableExtraStatistics() {
        return this.extraStatistics(false);
    }

    public PersistentSubscriptionSettingsBuilder extraStatistics(boolean value) {
        this.extraStatistics = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder checkpointAfterInMs(int value) {
        this.checkpointAfterMs = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder revision(long value) {
        this.revision = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder fromStreamStart() {
        return this.revision(0L);
    }

    public PersistentSubscriptionSettingsBuilder historyBufferSize(int value) {
        this.historyBufferSize = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder liveBufferSize(int value) {
        this.liveBufferSize = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder maxCheckpointCount(int value) {
        this.maxCheckpointCount = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder minCheckpointCount(int value) {
        this.minCheckpointCount = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder maxSubscriberCount(int value) {
        this.maxSubscriberCount = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder maxRetryCount(int value) {
        this.maxRetryCount = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder messageTimeoutInMs(int value) {
        this.messageTimeoutMs = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder readBatchSize(int value) {
        this.readBatchSize = value;
        return this;
    }

    public PersistentSubscriptionSettingsBuilder consumerStrategy(ConsumerStrategy strategy) {
        this.strategy = strategy;
        return this;
    }
}

