/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.PersistentSubscription;
import com.eventstore.dbclient.PersistentSubscriptionListener;
import com.eventstore.dbclient.ResolvedEvent;
import com.eventstore.dbclient.SubscribePersistentSubscriptionOptions;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import com.eventstore.dbclient.proto.shared.Shared;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

public class SubscribePersistentSubscription {
    private static final Persistent.ReadReq.Options.Builder defaultReadOptions = Persistent.ReadReq.Options.newBuilder().setUuidOption(Persistent.ReadReq.Options.UUIDOption.newBuilder().setStructured(Shared.Empty.getDefaultInstance()));
    private final GrpcClient connection;
    private final String stream;
    private final String group;
    private final PersistentSubscriptionListener listener;
    private final SubscribePersistentSubscriptionOptions options;

    public SubscribePersistentSubscription(GrpcClient connection, String stream, String group, SubscribePersistentSubscriptionOptions options, PersistentSubscriptionListener listener) {
        this.connection = connection;
        this.stream = stream;
        this.group = group;
        this.listener = listener;
        this.options = options;
    }

    public CompletableFuture execute() {
        return this.connection.run(channel -> {
            Metadata headers = this.options.getMetadata();
            PersistentSubscriptionsGrpc.PersistentSubscriptionsStub client = (PersistentSubscriptionsGrpc.PersistentSubscriptionsStub)MetadataUtils.attachHeaders((AbstractStub)PersistentSubscriptionsGrpc.newStub((Channel)channel), (Metadata)headers);
            final CompletableFuture result = new CompletableFuture();
            Shared.StreamIdentifier streamIdentifier = Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)this.stream)).build();
            final int bufferSize = this.options.getBufferSize();
            Persistent.ReadReq.Options options = defaultReadOptions.clone().setBufferSize(bufferSize).setStreamIdentifier(streamIdentifier).setGroupName(this.group).build();
            Persistent.ReadReq req = Persistent.ReadReq.newBuilder().setOptions(options).build();
            ClientResponseObserver<Persistent.ReadReq, Persistent.ReadResp> observer = new ClientResponseObserver<Persistent.ReadReq, Persistent.ReadResp>(){
                private boolean _confirmed;
                private PersistentSubscription _subscription;
                private ClientCallStreamObserver _requestStream;

                public void beforeStart(ClientCallStreamObserver<Persistent.ReadReq> requestStream) {
                    this._requestStream = requestStream;
                }

                public void onNext(Persistent.ReadResp readResp) {
                    if (!this._confirmed && readResp.hasSubscriptionConfirmation()) {
                        this._confirmed = true;
                        this._subscription = new PersistentSubscription((ClientCallStreamObserver<Persistent.ReadReq>)this._requestStream, readResp.getSubscriptionConfirmation().getSubscriptionId(), SubscribePersistentSubscription.this.stream, SubscribePersistentSubscription.this.group, bufferSize, defaultReadOptions);
                        result.complete(this._subscription);
                        return;
                    }
                    if (!this._confirmed && readResp.hasEvent()) {
                        this.onError(new IllegalStateException("Unconfirmed persistent subscription received event"));
                        return;
                    }
                    if (this._confirmed && !readResp.hasEvent()) {
                        this.onError(new IllegalStateException(String.format("Confirmed persistent subscription %s received non-{event,checkpoint} variant", this._subscription.getSubscriptionId())));
                        return;
                    }
                    SubscribePersistentSubscription.this.listener.onEvent(this._subscription, ResolvedEvent.fromWire(readResp.getEvent()));
                }

                public void onError(Throwable t) {
                    Status s;
                    if (t instanceof StatusRuntimeException && (s = ((StatusRuntimeException)t).getStatus()).getCode() == Status.Code.CANCELLED) {
                        SubscribePersistentSubscription.this.listener.onCancelled(this._subscription);
                        return;
                    }
                    SubscribePersistentSubscription.this.listener.onError(this._subscription, t);
                }

                public void onCompleted() {
                }
            };
            StreamObserver<Persistent.ReadReq> wireStream = client.read((StreamObserver<Persistent.ReadResp>)observer);
            wireStream.onNext((Object)req);
            return result;
        });
    }
}

