/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AbstractPersistentSubscriptionSettings;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractCreatePersistentSubscription {
    private final GrpcClient client;
    private final String group;
    private final AbstractPersistentSubscriptionSettings settings;
    private Metadata metadata;

    public AbstractCreatePersistentSubscription(GrpcClient client, String group, AbstractPersistentSubscriptionSettings settings, Metadata metadata) {
        this.client = client;
        this.group = group;
        this.settings = settings;
        this.metadata = metadata;
    }

    protected Persistent.CreateReq.Settings.Builder createSettings() {
        return Persistent.CreateReq.Settings.newBuilder();
    }

    protected abstract Persistent.CreateReq.Options.Builder createOptions();

    public CompletableFuture execute() {
        return this.client.run(channel -> {
            CompletableFuture result = new CompletableFuture();
            PersistentSubscriptionsGrpc.PersistentSubscriptionsStub client = (PersistentSubscriptionsGrpc.PersistentSubscriptionsStub)MetadataUtils.attachHeaders((AbstractStub)PersistentSubscriptionsGrpc.newStub((Channel)channel), (Metadata)this.metadata);
            Persistent.CreateReq.Settings.Builder settingsBuilder = this.createSettings();
            settingsBuilder.setResolveLinks(this.settings.isResolveLinks()).setReadBatchSize(this.settings.getReadBatchSize()).setMinCheckpointCount(this.settings.getMinCheckpointCount()).setMaxCheckpointCount(this.settings.getMaxCheckpointCount()).setMessageTimeoutMs(this.settings.getMessageTimeoutMs()).setMaxSubscriberCount(this.settings.getMaxSubscriberCount()).setMaxRetryCount(this.settings.getMaxRetryCount()).setLiveBufferSize(this.settings.getLiveBufferSize()).setHistoryBufferSize(this.settings.getHistoryBufferSize()).setExtraStatistics(this.settings.isExtraStatistics()).setCheckpointAfterMs(this.settings.getCheckpointAfterMs());
            switch (this.settings.getConsumerStrategyName()) {
                case "DispatchToSingle": {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.CreateReq.ConsumerStrategy.DispatchToSingle);
                    break;
                }
                case "RoundRobin": {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.CreateReq.ConsumerStrategy.RoundRobin);
                    break;
                }
                case "Pinned": {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.CreateReq.ConsumerStrategy.Pinned);
                }
            }
            Persistent.CreateReq req = Persistent.CreateReq.newBuilder().setOptions(this.createOptions().setSettings(settingsBuilder).setGroupName(this.group)).build();
            client.create(req, (StreamObserver<Persistent.CreateResp>)GrpcUtils.convertSingleResponse(result));
            return result;
        });
    }
}

