/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConsumerStrategy;
import java.time.Duration;

public abstract class AbstractPersistentSubscriptionSettings<T> {
    private int checkpointAfterMs;
    private boolean extraStatistics;
    private boolean resolveLinkTos;
    private int historyBufferSize;
    private int liveBufferSize;
    private int checkPointUpperBound;
    private int maxRetryCount;
    private int maxSubscriberCount;
    private int messageTimeoutMs;
    private int checkPointLowerBound;
    private int readBatchSize;
    private String consumerStrategyName;

    public AbstractPersistentSubscriptionSettings(int checkpointAfterMs, boolean extraStatistics, boolean resolveLinks, int historyBufferSize, int liveBufferSize, int checkPointUpperBound, int maxRetryCount, int maxSubscriberCount, int messageTimeoutMs, int minCheckpointCount, int readBatchSize, String consumerStrategyName) {
        this.checkpointAfterMs = checkpointAfterMs;
        this.extraStatistics = extraStatistics;
        this.resolveLinkTos = resolveLinks;
        this.historyBufferSize = historyBufferSize;
        this.liveBufferSize = liveBufferSize;
        this.checkPointUpperBound = checkPointUpperBound;
        this.maxRetryCount = maxRetryCount;
        this.maxSubscriberCount = maxSubscriberCount;
        this.messageTimeoutMs = messageTimeoutMs;
        this.checkPointLowerBound = minCheckpointCount;
        this.readBatchSize = readBatchSize;
        this.consumerStrategyName = consumerStrategyName;
    }

    public int getCheckpointAfterMs() {
        return this.checkpointAfterMs;
    }

    public Duration getCheckpointAfter() {
        return Duration.ofMillis(this.checkpointAfterMs);
    }

    public boolean isExtraStatistics() {
        return this.extraStatistics;
    }

    public boolean isResolveLinks() {
        return this.shouldResolveLinkTos();
    }

    public boolean shouldResolveLinkTos() {
        return this.resolveLinkTos;
    }

    public int getHistoryBufferSize() {
        return this.historyBufferSize;
    }

    public int getLiveBufferSize() {
        return this.liveBufferSize;
    }

    @Deprecated
    public int getMaxCheckpointCount() {
        return this.getCheckPointUpperBound();
    }

    public int getCheckPointUpperBound() {
        return this.checkPointUpperBound;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public int getMaxSubscriberCount() {
        return this.maxSubscriberCount;
    }

    public Duration getMessageTimeout() {
        return Duration.ofMillis(this.messageTimeoutMs);
    }

    public int getMessageTimeoutMs() {
        return this.messageTimeoutMs;
    }

    @Deprecated
    public int getMinCheckpointCount() {
        return this.getCheckPointLowerBound();
    }

    public int getCheckPointLowerBound() {
        return this.checkPointLowerBound;
    }

    public int getReadBatchSize() {
        return this.readBatchSize;
    }

    @Deprecated
    public ConsumerStrategy getStrategy() throws Exception {
        switch (this.consumerStrategyName) {
            case "DispatchToSingle": {
                return ConsumerStrategy.DispatchToSingle;
            }
            case "RoundRobin": {
                return ConsumerStrategy.RoundRobin;
            }
            case "Pinned": {
                return ConsumerStrategy.Pinned;
            }
        }
        throw new Exception("Non-default ConsumerStrategy specified, use getConsumerStrategyName()");
    }

    public String getConsumerStrategyName() {
        return this.consumerStrategyName;
    }
}

