/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AbstractPersistentSubscriptionSettings;
import com.eventstore.dbclient.ConsumerStrategy;
import com.eventstore.dbclient.NamedConsumerStrategy;
import java.time.Duration;

public class AbstractPersistentSubscriptionSettingsBuilder<T> {
    protected int checkpointAfterMs;
    protected boolean extraStatistics;
    protected boolean resolveLinkTos;
    protected int historyBufferSize;
    protected int liveBufferSize;
    protected int checkPointUpperBound;
    protected int maxRetryCount;
    protected int maxSubscriberCount;
    protected int messageTimeoutMs;
    protected int checkPointLowerBound;
    protected int readBatchSize;
    protected String consumerStrategyName;

    public AbstractPersistentSubscriptionSettingsBuilder() {
        this.checkpointAfterMs = 2000;
        this.resolveLinkTos = false;
        this.extraStatistics = false;
        this.messageTimeoutMs = 30000;
        this.maxRetryCount = 10;
        this.checkPointLowerBound = 10;
        this.checkPointUpperBound = 1000;
        this.maxSubscriberCount = 0;
        this.liveBufferSize = 500;
        this.readBatchSize = 20;
        this.historyBufferSize = 500;
        this.consumerStrategyName = "RoundRobin";
    }

    public AbstractPersistentSubscriptionSettingsBuilder(AbstractPersistentSubscriptionSettings settings) {
        this.checkpointAfterMs = settings.getCheckpointAfterMs();
        this.resolveLinkTos = settings.shouldResolveLinkTos();
        this.extraStatistics = settings.isExtraStatistics();
        this.messageTimeoutMs = settings.getMessageTimeoutMs();
        this.maxRetryCount = settings.getMaxRetryCount();
        this.checkPointLowerBound = settings.getCheckPointLowerBound();
        this.checkPointUpperBound = settings.getCheckPointUpperBound();
        this.maxSubscriberCount = settings.getMaxSubscriberCount();
        this.liveBufferSize = settings.getLiveBufferSize();
        this.readBatchSize = settings.getReadBatchSize();
        this.historyBufferSize = settings.getHistoryBufferSize();
        this.consumerStrategyName = settings.getConsumerStrategyName();
    }

    @Deprecated
    public T enableLinkResolution() {
        return this.resolveLinks(true);
    }

    @Deprecated
    public T disableLinkResolution() {
        return this.resolveLinks(false);
    }

    @Deprecated
    public T resolveLinks(boolean value) {
        return this.resolveLinkTos(value);
    }

    public T resolveLinkTos(boolean value) {
        this.resolveLinkTos = value;
        return (T)this;
    }

    public T resolveLinkTos() {
        return this.resolveLinkTos(true);
    }

    public T notResolveLinkTos() {
        return this.resolveLinkTos(false);
    }

    public T enableExtraStatistics() {
        return this.extraStatistics(true);
    }

    public T disableExtraStatistics() {
        return this.extraStatistics(false);
    }

    public T extraStatistics(boolean value) {
        this.extraStatistics = value;
        return (T)this;
    }

    public T checkpointAfter(Duration value) {
        this.checkpointAfterInMs((int)value.toMillis());
        return (T)this;
    }

    public T checkpointAfterInMs(int value) {
        this.checkpointAfterMs = value;
        return (T)this;
    }

    public T historyBufferSize(int value) {
        this.historyBufferSize = value;
        return (T)this;
    }

    public T liveBufferSize(int value) {
        this.liveBufferSize = value;
        return (T)this;
    }

    @Deprecated
    public T maxCheckpointCount(int value) {
        return this.checkPointUpperBound(value);
    }

    public T checkPointUpperBound(int value) {
        this.checkPointUpperBound = value;
        return (T)this;
    }

    @Deprecated
    public T minCheckpointCount(int value) {
        return this.checkPointLowerBound(this.checkPointLowerBound);
    }

    public T checkPointLowerBound(int value) {
        this.checkPointLowerBound = value;
        return (T)this;
    }

    public T maxSubscriberCount(int value) {
        this.maxSubscriberCount = value;
        return (T)this;
    }

    public T maxRetryCount(int value) {
        this.maxRetryCount = value;
        return (T)this;
    }

    public T messageTimeout(Duration value) {
        return this.messageTimeoutInMs((int)value.toMillis());
    }

    public T messageTimeoutInMs(int value) {
        this.messageTimeoutMs = value;
        return (T)this;
    }

    public T readBatchSize(int value) {
        this.readBatchSize = value;
        return (T)this;
    }

    public T consumerStrategy(ConsumerStrategy strategy) {
        this.consumerStrategyName = NamedConsumerStrategy.from(strategy);
        return (T)this;
    }

    public T namedConsumerStrategy(String value) {
        this.consumerStrategyName = value;
        return (T)this;
    }
}

