/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AbstractPersistentSubscriptionSettings;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractUpdatePersistentSubscription {
    private final GrpcClient connection;
    private final String group;
    private final AbstractPersistentSubscriptionSettings settings;
    private Metadata metadata;

    public AbstractUpdatePersistentSubscription(GrpcClient connection, String group, AbstractPersistentSubscriptionSettings settings, Metadata metadata) {
        this.connection = connection;
        this.group = group;
        this.settings = settings;
        this.metadata = metadata;
    }

    protected Persistent.UpdateReq.Settings.Builder createSettings() {
        return Persistent.UpdateReq.Settings.newBuilder();
    }

    protected abstract Persistent.UpdateReq.Options.Builder createOptions();

    public CompletableFuture execute() {
        return this.connection.run(channel -> {
            CompletableFuture result = new CompletableFuture();
            PersistentSubscriptionsGrpc.PersistentSubscriptionsStub client = (PersistentSubscriptionsGrpc.PersistentSubscriptionsStub)MetadataUtils.attachHeaders((AbstractStub)PersistentSubscriptionsGrpc.newStub((Channel)channel), (Metadata)this.metadata);
            Persistent.UpdateReq.Settings.Builder settingsBuilder = this.createSettings();
            settingsBuilder.setResolveLinks(this.settings.isResolveLinks()).setReadBatchSize(this.settings.getReadBatchSize()).setMinCheckpointCount(this.settings.getMinCheckpointCount()).setMaxCheckpointCount(this.settings.getMaxCheckpointCount()).setMessageTimeoutMs(this.settings.getMessageTimeoutMs()).setMaxSubscriberCount(this.settings.getMaxSubscriberCount()).setMaxRetryCount(this.settings.getMaxRetryCount()).setLiveBufferSize(this.settings.getLiveBufferSize()).setHistoryBufferSize(this.settings.getHistoryBufferSize()).setExtraStatistics(this.settings.isExtraStatistics()).setCheckpointAfterMs(this.settings.getCheckpointAfterMs());
            switch (this.settings.getConsumerStrategyName()) {
                case "DispatchToSingle": {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.DispatchToSingle);
                    break;
                }
                case "RoundRobin": {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.RoundRobin);
                    break;
                }
                case "Pinned": {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.Pinned);
                }
            }
            Persistent.UpdateReq req = Persistent.UpdateReq.newBuilder().setOptions(this.createOptions().setSettings(settingsBuilder).setGroupName(this.group)).build();
            client.update(req, (StreamObserver<Persistent.UpdateResp>)GrpcUtils.convertSingleResponse(result));
            return result;
        });
    }
}

