/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AppendToStreamOptions;
import com.eventstore.dbclient.EventData;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.NotLeaderException;
import com.eventstore.dbclient.Position;
import com.eventstore.dbclient.StreamRevision;
import com.eventstore.dbclient.WriteResult;
import com.eventstore.dbclient.WrongExpectedVersionException;
import com.eventstore.dbclient.proto.shared.Shared;
import com.eventstore.dbclient.proto.streams.StreamsGrpc;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AppendToStream {
    private final GrpcClient client;
    private final String streamName;
    private final List<EventData> events;
    private final AppendToStreamOptions options;

    public AppendToStream(GrpcClient client, String streamName, Iterator<EventData> events, AppendToStreamOptions options) {
        this.client = client;
        this.streamName = streamName;
        this.events = new ArrayList<EventData>();
        while (events.hasNext()) {
            this.events.add(events.next());
        }
        this.options = options;
    }

    public CompletableFuture<WriteResult> execute() {
        return this.client.run(channel -> {
            Metadata headers = this.options.getMetadata();
            CompletableFuture result = new CompletableFuture();
            StreamsOuterClass.AppendReq.Options.Builder options = this.options.getExpectedRevision().applyOnWire(StreamsOuterClass.AppendReq.Options.newBuilder().setStreamIdentifier(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)this.streamName)).build()));
            StreamsGrpc.StreamsStub client = (StreamsGrpc.StreamsStub)MetadataUtils.attachHeaders((AbstractStub)StreamsGrpc.newStub((Channel)channel), (Metadata)headers);
            StreamObserver<StreamsOuterClass.AppendReq> requestStream = client.append((StreamObserver<StreamsOuterClass.AppendResp>)GrpcUtils.convertSingleResponse(result, resp -> {
                if (resp.hasSuccess()) {
                    StreamsOuterClass.AppendResp.Success success = resp.getSuccess();
                    StreamRevision nextExpectedRevision = success.getCurrentRevisionOptionCase() == StreamsOuterClass.AppendResp.Success.CurrentRevisionOptionCase.NO_STREAM ? new StreamRevision(1L) : new StreamRevision(success.getCurrentRevision());
                    Position logPosition = null;
                    if (success.getPositionOptionCase() == StreamsOuterClass.AppendResp.Success.PositionOptionCase.POSITION) {
                        StreamsOuterClass.AppendResp.Position p = success.getPosition();
                        logPosition = new Position(p.getCommitPosition(), p.getPreparePosition());
                    }
                    return new WriteResult(nextExpectedRevision, logPosition);
                }
                if (resp.hasWrongExpectedVersion()) {
                    StreamsOuterClass.AppendResp.WrongExpectedVersion wev = resp.getWrongExpectedVersion();
                    StreamRevision expectedRevision = wev.getExpectedRevisionOptionCase() == StreamsOuterClass.AppendResp.WrongExpectedVersion.ExpectedRevisionOptionCase.EXPECTED_ANY ? new StreamRevision(2L) : (wev.getExpectedRevisionOptionCase() == StreamsOuterClass.AppendResp.WrongExpectedVersion.ExpectedRevisionOptionCase.EXPECTED_STREAM_EXISTS ? new StreamRevision(4L) : new StreamRevision(wev.getExpectedRevision()));
                    StreamRevision currentRevision = wev.getCurrentRevisionOptionCase() == StreamsOuterClass.AppendResp.WrongExpectedVersion.CurrentRevisionOptionCase.CURRENT_NO_STREAM ? new StreamRevision(2L) : new StreamRevision(wev.getCurrentRevision());
                    String streamName = options.getStreamIdentifier().getStreamName().toStringUtf8();
                    throw new WrongExpectedVersionException(streamName, expectedRevision, currentRevision);
                }
                throw new IllegalStateException("AppendResponse has neither Success or WrongExpectedVersion variants");
            }));
            try {
                requestStream.onNext((Object)StreamsOuterClass.AppendReq.newBuilder().setOptions(options).build());
                for (EventData e : this.events) {
                    StreamsOuterClass.AppendReq.ProposedMessage.Builder msgBuilder = StreamsOuterClass.AppendReq.ProposedMessage.newBuilder().setId(Shared.UUID.newBuilder().setStructured(Shared.UUID.Structured.newBuilder().setMostSignificantBits(e.getEventId().getMostSignificantBits()).setLeastSignificantBits(e.getEventId().getLeastSignificantBits()))).setData(ByteString.copyFrom((byte[])e.getEventData())).putMetadata("content-type", e.getContentType()).putMetadata("type", e.getEventType());
                    if (e.getUserMetadata() != null) {
                        msgBuilder.setCustomMetadata(ByteString.copyFrom((byte[])e.getUserMetadata()));
                    }
                    requestStream.onNext((Object)StreamsOuterClass.AppendReq.newBuilder().setProposedMessage(msgBuilder).build());
                }
                requestStream.onCompleted();
            }
            catch (StatusRuntimeException e) {
                String leaderHost = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-host", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                String leaderPort = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-port", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                if (leaderHost != null && leaderPort != null) {
                    NotLeaderException reason = new NotLeaderException(leaderHost, Integer.valueOf(leaderPort));
                    result.completeExceptionally(reason);
                } else {
                    result.completeExceptionally(e);
                }
            }
            catch (RuntimeException e) {
                result.completeExceptionally(e);
            }
            return result;
        });
    }
}

