/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Consts;
import com.eventstore.dbclient.Endpoint;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.NodePreference;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionSettingsBuilder {
    private final Logger logger = LoggerFactory.getLogger(ConnectionSettingsBuilder.class);
    private boolean _dnsDiscover = false;
    private int _maxDiscoverAttempts = 3;
    private int _discoveryInterval = 500;
    private int _gossipTimeout = 3000;
    private NodePreference _nodePreference = NodePreference.RANDOM;
    private boolean _tls = true;
    private boolean _tlsVerifyCert = true;
    private boolean _throwOnAppendFailure = true;
    private EventStoreDBClientSettings.Credentials _defaultCredentials;
    private LinkedList<Endpoint> _hosts = new LinkedList();
    private long _keepAliveTimeout = Consts.DEFAULT_KEEP_ALIVE_TIMEOUT_IN_MS;
    private long _keepAliveInterval = Consts.DEFAULT_KEEP_ALIVE_INTERVAL_IN_MS;

    public EventStoreDBClientSettings buildConnectionSettings() {
        return new EventStoreDBClientSettings(this._dnsDiscover, this._maxDiscoverAttempts, this._discoveryInterval, this._gossipTimeout, this._nodePreference, this._tls, this._tlsVerifyCert, this._throwOnAppendFailure, this._defaultCredentials, this._hosts.toArray(new Endpoint[this._hosts.size()]), this._keepAliveTimeout, this._keepAliveInterval);
    }

    public ConnectionSettingsBuilder dnsDiscover(boolean dnsDiscover) {
        this._dnsDiscover = dnsDiscover;
        return this;
    }

    public ConnectionSettingsBuilder maxDiscoverAttempts(int maxDiscoverAttempts) {
        this._maxDiscoverAttempts = maxDiscoverAttempts;
        return this;
    }

    public ConnectionSettingsBuilder discoveryInterval(int discoveryInterval) {
        this._discoveryInterval = discoveryInterval;
        return this;
    }

    public ConnectionSettingsBuilder gossipTimeout(int gossipTimeout) {
        this._gossipTimeout = gossipTimeout;
        return this;
    }

    public ConnectionSettingsBuilder nodePreference(NodePreference nodePreference) {
        this._nodePreference = nodePreference;
        return this;
    }

    public ConnectionSettingsBuilder tls(boolean tls) {
        this._tls = tls;
        return this;
    }

    public ConnectionSettingsBuilder tlsVerifyCert(boolean tlsVerifyCert) {
        this._tlsVerifyCert = tlsVerifyCert;
        return this;
    }

    public ConnectionSettingsBuilder throwOnAppendFailure(boolean throwOnAppendFailure) {
        this._throwOnAppendFailure = throwOnAppendFailure;
        return this;
    }

    public ConnectionSettingsBuilder defaultCredentials(String username, String password) {
        this._defaultCredentials = new EventStoreDBClientSettings.Credentials(username, password);
        return this;
    }

    public ConnectionSettingsBuilder addHost(Endpoint host) {
        this._hosts.push(host);
        return this;
    }

    public ConnectionSettingsBuilder keepAliveTimeout(long value) {
        if (value >= 0L && value < Consts.DEFAULT_KEEP_ALIVE_TIMEOUT_IN_MS) {
            this.logger.warn("Specified keepAliveTimeout of {} is less than recommended {}", (Object)value, (Object)Consts.DEFAULT_KEEP_ALIVE_TIMEOUT_IN_MS);
        } else {
            if (value == -1L) {
                value = Long.MAX_VALUE;
            }
            this._keepAliveTimeout = value;
        }
        return this;
    }

    public ConnectionSettingsBuilder keepAliveInterval(long value) {
        if (value >= 0L && value < Consts.DEFAULT_KEEP_ALIVE_INTERVAL_IN_MS) {
            this.logger.warn("Specified keepAliveInterval of {} is less than recommended {}", (Object)value, (Object)Consts.DEFAULT_KEEP_ALIVE_INTERVAL_IN_MS);
        } else {
            if (value == -1L) {
                value = Long.MAX_VALUE;
            }
            this._keepAliveInterval = value;
        }
        return this;
    }
}

