/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AbstractCreatePersistentSubscription;
import com.eventstore.dbclient.AbstractPersistentSubscriptionSettings;
import com.eventstore.dbclient.CreatePersistentSubscriptionOptions;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.PersistentSubscriptionSettings;
import com.eventstore.dbclient.StreamRevision;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.shared.Shared;
import com.google.protobuf.ByteString;

public class CreatePersistentSubscription
extends AbstractCreatePersistentSubscription {
    private final String stream;
    private final PersistentSubscriptionSettings settings;

    public CreatePersistentSubscription(GrpcClient client, String stream, String group, CreatePersistentSubscriptionOptions options) {
        super(client, group, (AbstractPersistentSubscriptionSettings)options.getSettings(), options.getMetadata());
        this.stream = stream;
        this.settings = (PersistentSubscriptionSettings)options.getSettings();
    }

    @Override
    protected Persistent.CreateReq.Settings.Builder createSettings() {
        return Persistent.CreateReq.Settings.newBuilder().setRevision(this.settings.getRevision());
    }

    @Override
    protected Persistent.CreateReq.Options.Builder createOptions() {
        Persistent.CreateReq.Options.Builder optionsBuilder = Persistent.CreateReq.Options.newBuilder();
        Shared.StreamIdentifier.Builder streamIdentifierBuilder = Shared.StreamIdentifier.newBuilder();
        Persistent.CreateReq.StreamOptions.Builder streamOptionsBuilder = Persistent.CreateReq.StreamOptions.newBuilder();
        if (this.settings.getStreamRevision() == StreamRevision.START) {
            streamOptionsBuilder.setStart(Shared.Empty.newBuilder());
        } else if (this.settings.getStreamRevision() == StreamRevision.END) {
            streamOptionsBuilder.setEnd(Shared.Empty.newBuilder());
        } else {
            streamOptionsBuilder.setRevision(this.settings.getRevision());
        }
        streamIdentifierBuilder.setStreamName(ByteString.copyFromUtf8((String)this.stream));
        streamOptionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        optionsBuilder.setStream(streamOptionsBuilder);
        optionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        return optionsBuilder;
    }
}

