/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.CreateProjectionOptions;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.UpdateProjection;
import com.eventstore.dbclient.UpdateProjectionOptions;
import com.eventstore.dbclient.proto.projections.Projectionmanagement;
import com.eventstore.dbclient.proto.projections.ProjectionsGrpc;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

public class CreateProjection {
    private final GrpcClient client;
    private final String projectionName;
    private final String query;
    private final boolean trackEmittedStreams;
    private final boolean emitEnabled;
    private final Metadata metadata;

    public CreateProjection(GrpcClient client, String projectionName, String query, CreateProjectionOptions options) {
        this.client = client;
        this.projectionName = projectionName;
        this.query = query;
        this.trackEmittedStreams = options.isTrackingEmittedStreams();
        this.emitEnabled = options.isEmitEnabled();
        this.metadata = options.getMetadata();
    }

    public CompletableFuture execute() {
        return this.client.run(channel -> {
            Projectionmanagement.CreateReq.Options.Continuous.Builder continuousBuilder = Projectionmanagement.CreateReq.Options.Continuous.newBuilder().setName(this.projectionName).setTrackEmittedStreams(this.trackEmittedStreams);
            Projectionmanagement.CreateReq.Options.Builder optionsBuilder = Projectionmanagement.CreateReq.Options.newBuilder().setQuery(this.query).setContinuous(continuousBuilder);
            Projectionmanagement.CreateReq request = Projectionmanagement.CreateReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = (ProjectionsGrpc.ProjectionsStub)MetadataUtils.attachHeaders((AbstractStub)ProjectionsGrpc.newStub((Channel)channel), (Metadata)this.metadata);
            CompletableFuture result = new CompletableFuture();
            client.create(request, (StreamObserver<Projectionmanagement.CreateResp>)GrpcUtils.convertSingleResponse(result));
            return result;
        }).thenApplyAsync(result -> {
            if (this.emitEnabled) {
                UpdateProjectionOptions options = UpdateProjectionOptions.get().emitEnabled(true);
                UpdateProjection update = new UpdateProjection(this.client, this.projectionName, this.query, options);
                return update.execute().thenApply(x -> result);
            }
            return CompletableFuture.completedFuture(result);
        });
    }
}

