/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Endpoint;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.EventStoreDBClusterClient;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.SingleNodeClient;
import com.eventstore.dbclient.UserCredentials;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStoreDBClientBase {
    final Logger logger = LoggerFactory.getLogger(EventStoreDBClientBase.class);
    protected final GrpcClient client;
    protected final UserCredentials credentials;

    protected EventStoreDBClientBase(EventStoreDBClientSettings settings) {
        this.credentials = settings.getDefaultCredentials() != null ? settings.getDefaultCredentials().toUserCredentials() : null;
        SslContext sslContext = null;
        if (settings.isTls()) {
            try {
                SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
                if (!settings.isTlsVerifyCert()) {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                sslContext = sslContextBuilder.build();
            }
            catch (SSLException e) {
                this.logger.error("Exception when creating SSL context", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (settings.isDnsDiscover()) {
            this.client = new EventStoreDBClusterClient(null, settings.getHosts()[0], settings.getNodePreference(), sslContext, settings);
            return;
        }
        if (settings.getHosts().length > 1) {
            ArrayList<InetSocketAddress> seeds = new ArrayList<InetSocketAddress>();
            for (Endpoint seed : settings.getHosts()) {
                seeds.add(new InetSocketAddress(seed.getHostname(), seed.getPort()));
            }
            this.client = new EventStoreDBClusterClient(seeds, null, settings.getNodePreference(), sslContext, settings);
            return;
        }
        this.client = new SingleNodeClient(settings.getHosts()[0].getHostname(), settings.getHosts()[0].getPort(), sslContext, settings);
    }

    public void shutdown() throws ExecutionException, InterruptedException {
        this.client.shutdown();
    }
}

