/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.GetProjectionStatisticsOptions;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.ProjectionDetails;
import com.eventstore.dbclient.proto.projections.Projectionmanagement;
import com.eventstore.dbclient.proto.projections.ProjectionsGrpc;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

public class GetProjectionStatistics {
    private final GrpcClient client;
    private final String projectionName;
    private final Metadata metadata;

    public GetProjectionStatistics(GrpcClient client, String projectionName, GetProjectionStatisticsOptions options) {
        this.client = client;
        this.projectionName = projectionName;
        this.metadata = options.getMetadata();
    }

    public CompletableFuture<ProjectionDetails> execute() {
        return this.client.run(channel -> {
            Projectionmanagement.StatisticsReq.Options.Builder optionsBuilder = Projectionmanagement.StatisticsReq.Options.newBuilder().setName(this.projectionName);
            Projectionmanagement.StatisticsReq request = Projectionmanagement.StatisticsReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = (ProjectionsGrpc.ProjectionsStub)MetadataUtils.attachHeaders((AbstractStub)ProjectionsGrpc.newStub((Channel)channel), (Metadata)this.metadata);
            CompletableFuture result = new CompletableFuture();
            client.statistics(request, (StreamObserver<Projectionmanagement.StatisticsResp>)GrpcUtils.convertSingleResponse(result, resp -> {
                Projectionmanagement.StatisticsResp.Details details = resp.getDetails();
                return ProjectionDetails.fromWire(details);
            }));
            return result;
        });
    }
}

