/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.ListProjectionsOptions;
import com.eventstore.dbclient.ListProjectionsResult;
import com.eventstore.dbclient.ProjectionDetails;
import com.eventstore.dbclient.proto.projections.Projectionmanagement;
import com.eventstore.dbclient.proto.projections.ProjectionsGrpc;
import com.eventstore.dbclient.proto.shared.Shared;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class ListProjections {
    private final GrpcClient client;
    private final Metadata metadata;

    public ListProjections(GrpcClient client, ListProjectionsOptions options) {
        this.client = client;
        this.metadata = options.getMetadata();
    }

    public CompletableFuture<ListProjectionsResult> execute() {
        return this.client.run(channel -> {
            Projectionmanagement.StatisticsReq.Options.Builder optionsBuilder = Projectionmanagement.StatisticsReq.Options.newBuilder().setContinuous(Shared.Empty.newBuilder());
            Projectionmanagement.StatisticsReq request = Projectionmanagement.StatisticsReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = (ProjectionsGrpc.ProjectionsStub)MetadataUtils.attachHeaders((AbstractStub)ProjectionsGrpc.newStub((Channel)channel), (Metadata)this.metadata);
            final CompletableFuture future = new CompletableFuture();
            final ArrayList projections = new ArrayList();
            client.statistics(request, new StreamObserver<Projectionmanagement.StatisticsResp>(){

                public void onNext(Projectionmanagement.StatisticsResp value) {
                    if (value.hasDetails()) {
                        projections.add(ProjectionDetails.fromWire(value.getDetails()));
                    }
                }

                public void onCompleted() {
                    future.complete(new ListProjectionsResult(projections));
                }

                public void onError(Throwable t) {
                    future.completeExceptionally(t);
                }
            });
            return future;
        });
    }
}

