/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionMetadata;
import com.eventstore.dbclient.Timeouts;
import com.eventstore.dbclient.UserCredentials;
import io.grpc.Metadata;

class OptionsBase<T> {
    protected Timeouts timeouts = Timeouts.DEFAULT;
    protected final ConnectionMetadata metadata = new ConnectionMetadata();

    protected OptionsBase() {
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public T timeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        return (T)this;
    }

    public Metadata getMetadata() {
        return this.metadata.build();
    }

    public boolean hasUserCredentials() {
        return this.metadata.hasUserCredentials();
    }

    public T authenticated(UserCredentials credentials) {
        if (credentials == null) {
            return (T)this;
        }
        this.metadata.authenticated(credentials);
        return (T)this;
    }

    public T requiresLeader() {
        return this.requiresLeader(true);
    }

    public T notRequireLeader() {
        return this.requiresLeader(false);
    }

    public T requiresLeader(boolean value) {
        if (value) {
            this.metadata.requiresLeader();
        }
        return (T)this;
    }
}

