/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AbstractPersistentSubscriptionSettings;
import com.eventstore.dbclient.ConsumerStrategy;
import com.eventstore.dbclient.NamedConsumerStrategy;
import com.eventstore.dbclient.PersistentSubscriptionSettingsBuilder;
import com.eventstore.dbclient.StreamRevision;

public class PersistentSubscriptionSettings
extends AbstractPersistentSubscriptionSettings {
    protected StreamRevision revision;

    public PersistentSubscriptionSettings(int checkpointAfterMs, boolean extraStatistics, boolean resolveLinks, int historyBufferSize, int liveBufferSize, int maxCheckpointCount, int maxRetryCount, int maxSubscriberCount, int messageTimeoutMs, int minCheckpointCount, int readBatchSize, long revision, ConsumerStrategy strategy) {
        this(checkpointAfterMs, extraStatistics, resolveLinks, historyBufferSize, liveBufferSize, maxCheckpointCount, maxRetryCount, maxSubscriberCount, messageTimeoutMs, minCheckpointCount, readBatchSize, new StreamRevision(revision), NamedConsumerStrategy.from(strategy));
    }

    public PersistentSubscriptionSettings(int checkpointAfterMs, boolean extraStatistics, boolean resolveLinks, int historyBufferSize, int liveBufferSize, int maxCheckpointCount, int maxRetryCount, int maxSubscriberCount, int messageTimeoutMs, int minCheckpointCount, int readBatchSize, StreamRevision revision, String consumerStrategyName) {
        super(checkpointAfterMs, extraStatistics, resolveLinks, historyBufferSize, liveBufferSize, maxCheckpointCount, maxRetryCount, maxSubscriberCount, messageTimeoutMs, minCheckpointCount, readBatchSize, consumerStrategyName);
        this.revision = revision;
    }

    public long getRevision() {
        return this.revision.getValueUnsigned();
    }

    public StreamRevision getStreamRevision() {
        return this.revision;
    }

    public static PersistentSubscriptionSettingsBuilder builder() {
        return new PersistentSubscriptionSettingsBuilder();
    }

    public static PersistentSubscriptionSettingsBuilder copy(PersistentSubscriptionSettings settings) {
        return new PersistentSubscriptionSettingsBuilder(settings);
    }
}

