/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Timeouts;
import java.util.concurrent.TimeUnit;

public class TimeoutsBuilder {
    long shutdownTimeout;
    TimeUnit shutdownTimeoutUnit;
    long subscriptionTimeout;
    TimeUnit subscriptionTimeoutUnit;

    public static TimeoutsBuilder newBuilder() {
        TimeoutsBuilder builder = new TimeoutsBuilder();
        builder.shutdownTimeout = Timeouts.DEFAULT.shutdownTimeout;
        builder.shutdownTimeoutUnit = Timeouts.DEFAULT.shutdownTimeoutUnit;
        return builder;
    }

    public TimeoutsBuilder withShutdownTimeout(long timeout, TimeUnit timeoutUnit) {
        this.shutdownTimeout = timeout;
        this.shutdownTimeoutUnit = timeoutUnit;
        return this;
    }

    public TimeoutsBuilder withSubscriptionTimeout(long timeout, TimeUnit timeoutUnit) {
        this.subscriptionTimeout = timeout;
        this.subscriptionTimeoutUnit = timeoutUnit;
        return this;
    }

    public Timeouts build() {
        return new Timeouts(this.shutdownTimeout, this.shutdownTimeoutUnit, this.subscriptionTimeout, this.subscriptionTimeoutUnit);
    }

    private TimeoutsBuilder() {
    }
}

