/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AbstractPersistentSubscriptionSettings;
import com.eventstore.dbclient.AbstractUpdatePersistentSubscription;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.PersistentSubscriptionSettings;
import com.eventstore.dbclient.StreamRevision;
import com.eventstore.dbclient.UpdatePersistentSubscriptionOptions;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.shared.Shared;
import com.google.protobuf.ByteString;

public class UpdatePersistentSubscription
extends AbstractUpdatePersistentSubscription {
    private final PersistentSubscriptionSettings settings;
    private String stream;

    public UpdatePersistentSubscription(GrpcClient connection, String stream, String group, UpdatePersistentSubscriptionOptions options) {
        super(connection, group, (AbstractPersistentSubscriptionSettings)options.getSettings(), options.getMetadata());
        this.stream = stream;
        this.settings = (PersistentSubscriptionSettings)options.getSettings();
    }

    @Override
    protected Persistent.UpdateReq.Settings.Builder createSettings() {
        return Persistent.UpdateReq.Settings.newBuilder().setRevision(this.settings.getRevision());
    }

    @Override
    protected Persistent.UpdateReq.Options.Builder createOptions() {
        Persistent.UpdateReq.Options.Builder optionsBuilder = Persistent.UpdateReq.Options.newBuilder();
        Shared.StreamIdentifier.Builder streamIdentifierBuilder = Shared.StreamIdentifier.newBuilder();
        Persistent.UpdateReq.StreamOptions.Builder streamOptionsBuilder = Persistent.UpdateReq.StreamOptions.newBuilder();
        if (this.settings.getStreamRevision() == StreamRevision.START) {
            streamOptionsBuilder.setStart(Shared.Empty.newBuilder());
        } else if (this.settings.getStreamRevision() == StreamRevision.END) {
            streamOptionsBuilder.setEnd(Shared.Empty.newBuilder());
        } else {
            streamOptionsBuilder.setRevision(this.settings.getRevision());
        }
        streamIdentifierBuilder.setStreamName(ByteString.copyFromUtf8((String)this.stream));
        streamOptionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        optionsBuilder.setStream(streamOptionsBuilder);
        optionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        return optionsBuilder;
    }
}

