/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk;

import com.eway.payment.rapid.sdk.RapidClient;
import com.eway.payment.rapid.sdk.beans.external.Customer;
import com.eway.payment.rapid.sdk.beans.external.PaymentMethod;
import com.eway.payment.rapid.sdk.beans.external.Refund;
import com.eway.payment.rapid.sdk.beans.external.Transaction;
import com.eway.payment.rapid.sdk.beans.external.TransactionFilter;
import com.eway.payment.rapid.sdk.entities.CreateCustomerResponse;
import com.eway.payment.rapid.sdk.exception.APIKeyInvalidException;
import com.eway.payment.rapid.sdk.exception.ParameterInvalidException;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.process.AbstractMakeRequestMessageProcess;
import com.eway.payment.rapid.sdk.message.process.customer.CustDirectPaymentMsgProcess;
import com.eway.payment.rapid.sdk.message.process.customer.CustDirectUpdateMsgProcess;
import com.eway.payment.rapid.sdk.message.process.customer.CustResponsiveSharedMsgProcess;
import com.eway.payment.rapid.sdk.message.process.customer.CustResponsiveUpdateMsgProcess;
import com.eway.payment.rapid.sdk.message.process.customer.CustTransparentRedirectMsgProcess;
import com.eway.payment.rapid.sdk.message.process.customer.CustTransparentUpdateMsgProcess;
import com.eway.payment.rapid.sdk.message.process.customer.QueryCustomerMsgProcess;
import com.eway.payment.rapid.sdk.message.process.refund.CancelAuthorisationMsgProcess;
import com.eway.payment.rapid.sdk.message.process.refund.CapturePaymentMsgProcess;
import com.eway.payment.rapid.sdk.message.process.refund.RefundMsgProcess;
import com.eway.payment.rapid.sdk.message.process.transaction.TransDirectPaymentMsgProcess;
import com.eway.payment.rapid.sdk.message.process.transaction.TransQueryMsgProcess;
import com.eway.payment.rapid.sdk.message.process.transaction.TransResponsiveSharedMsgProcess;
import com.eway.payment.rapid.sdk.message.process.transaction.TransTransparentRedirectMsgProcess;
import com.eway.payment.rapid.sdk.output.CreateTransactionResponse;
import com.eway.payment.rapid.sdk.output.QueryCustomerResponse;
import com.eway.payment.rapid.sdk.output.QueryTransactionResponse;
import com.eway.payment.rapid.sdk.output.RefundResponse;
import com.eway.payment.rapid.sdk.output.ResponseOutput;
import com.eway.payment.rapid.sdk.util.RapidClientFilter;
import com.eway.payment.rapid.sdk.util.ResourceUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RapidClientImpl
implements RapidClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RapidClient.class);
    private String APIKey;
    private String password;
    private String webUrl;
    private String rapidEndpoint;
    private String apiVersion;
    private boolean debug;
    private boolean isValid;
    private List<String> listError;

    protected String getAPIKey() {
        return this.APIKey;
    }

    protected RapidClientImpl(String APIKey, String password, String rapidEndpoint) {
        LOGGER.info("Initiate client with end point:" + rapidEndpoint);
        this.APIKey = APIKey;
        this.password = password;
        this.rapidEndpoint = rapidEndpoint;
        this.debug = false;
        this.validateAPIParam();
    }

    @Override
    public void setCredentials(String APIKey, String password) {
        this.APIKey = APIKey;
        this.password = password;
        this.validateAPIParam();
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.rapidEndpoint = endpoint;
        this.validateAPIParam();
    }

    @Override
    public void setDebug(boolean debug) {
        LOGGER.info("eWAY Rapid SDK debug mode set to " + debug);
        this.debug = debug;
    }

    @Override
    public void setVersion(String version) {
        LOGGER.info("eWAY Rapid SDK version set to " + version);
        this.apiVersion = version;
    }

    private void validateAPIParam() {
        this.isValid = true;
        if (StringUtils.isBlank((CharSequence)this.APIKey) || StringUtils.isBlank((CharSequence)this.password)) {
            this.addErrorCode("S9991");
            this.isValid = false;
        }
        if (StringUtils.isBlank((CharSequence)this.rapidEndpoint)) {
            this.addErrorCode("S9990");
            this.isValid = false;
        }
        if (this.isValid) {
            try {
                this.parserRapidEnpointToGetWebUrl();
                if (this.listError != null) {
                    this.listError.clear();
                }
                this.isValid = true;
                LOGGER.info("Initiate client[" + this.rapidEndpoint + "] successful!");
            }
            catch (Exception e) {
                LOGGER.error("Error loading or connecting to endpoint", (Throwable)e);
                this.isValid = false;
                this.addErrorCode("S9990");
            }
        } else {
            LOGGER.warn("Rapid client [" + this.rapidEndpoint + "] has invalid credentials");
        }
    }

    private void parserRapidEnpointToGetWebUrl() throws Exception {
        String propName = null;
        if ("Production".equalsIgnoreCase(this.rapidEndpoint)) {
            propName = "global.rapid.rest.production.url";
        } else if ("Sandbox".equalsIgnoreCase(this.rapidEndpoint)) {
            propName = "global.rapid.rest.sandbox.url";
        }
        if (StringUtils.isBlank((CharSequence)propName)) {
            this.webUrl = this.rapidEndpoint;
        } else {
            Properties prop = ResourceUtil.loadProperiesOnResourceFolder("rapid-api.properties");
            this.webUrl = prop.getProperty(propName);
            if (StringUtils.isBlank((CharSequence)this.webUrl)) {
                throw new Exception("The endpoint " + propName + " is invalid.");
            }
        }
        this.verifyEndpointUrl(this.webUrl);
    }

    private void verifyEndpointUrl(String endpointUrl) throws Exception {
        URL url = new URL(endpointUrl);
        URLConnection conn = url.openConnection();
        conn.connect();
    }

    @Override
    public CreateTransactionResponse create(PaymentMethod paymentMethod, Transaction transaction) {
        if (!this.isValid()) {
            return this.makeResponseWithException(new APIKeyInvalidException("API Key, Password or Rapid endpoint is invalid"), CreateTransactionResponse.class);
        }
        try {
            AbstractMakeRequestMessageProcess process = null;
            switch (paymentMethod) {
                case Direct: {
                    process = new TransDirectPaymentMsgProcess(this.getEwayWebResource(), "DirectPayment".concat(".json"));
                    break;
                }
                case ResponsiveShared: {
                    process = new TransResponsiveSharedMsgProcess(this.getEwayWebResource(), "CreateAccessCodeShared".concat(".json"));
                    break;
                }
                case TransparentRedirect: {
                    process = new TransTransparentRedirectMsgProcess(this.getEwayWebResource(), "CreateAccessCode".concat(".json"));
                    break;
                }
                case Wallet: {
                    if (transaction.isCapture()) {
                        process = new TransDirectPaymentMsgProcess(this.getEwayWebResource(), "DirectPayment".concat(".json"));
                        break;
                    }
                    process = new CapturePaymentMsgProcess(this.getEwayWebResource(), "CapturePayment");
                    break;
                }
                case Authorisation: {
                    process = new CapturePaymentMsgProcess(this.getEwayWebResource(), "CapturePayment");
                    break;
                }
                default: {
                    return this.makeResponseWithException(new ParameterInvalidException("Unsupported Payment Method"), CreateTransactionResponse.class);
                }
            }
            return (CreateTransactionResponse)process.doWork(transaction);
        }
        catch (RapidSdkException e) {
            LOGGER.error(e.getMessage());
            return this.makeResponseWithException(e, CreateTransactionResponse.class);
        }
    }

    @Override
    public CreateCustomerResponse create(PaymentMethod PaymentMethod2, Customer customer) {
        if (!this.isValid()) {
            return this.makeResponseWithException(new APIKeyInvalidException("API Key, Password or Rapid endpoint is invalid"), CreateCustomerResponse.class);
        }
        try {
            AbstractMakeRequestMessageProcess process = null;
            switch (PaymentMethod2) {
                case Direct: {
                    process = new CustDirectPaymentMsgProcess(this.getEwayWebResource(), "DirectPayment".concat(".json"));
                    break;
                }
                case ResponsiveShared: {
                    process = new CustResponsiveSharedMsgProcess(this.getEwayWebResource(), "CreateAccessCodeShared".concat(".json"));
                    break;
                }
                case TransparentRedirect: {
                    process = new CustTransparentRedirectMsgProcess(this.getEwayWebResource(), "CreateAccessCode".concat(".json"));
                    break;
                }
                default: {
                    return this.makeResponseWithException(new ParameterInvalidException("Unsupported Payment Method"), CreateCustomerResponse.class);
                }
            }
            return (CreateCustomerResponse)process.doWork(customer);
        }
        catch (RapidSdkException e) {
            LOGGER.error(e.getMessage());
            return this.makeResponseWithException(e, CreateCustomerResponse.class);
        }
    }

    @Override
    public CreateCustomerResponse update(PaymentMethod paymentMethod, Customer customer) {
        if (!this.isValid()) {
            return this.makeResponseWithException(new APIKeyInvalidException("APIKey, password or rapid endpoint param had been null or empty"), CreateCustomerResponse.class);
        }
        try {
            AbstractMakeRequestMessageProcess process = null;
            switch (paymentMethod) {
                case Direct: {
                    process = new CustDirectUpdateMsgProcess(this.getEwayWebResource(), "DirectPayment".concat(".json"));
                    break;
                }
                case ResponsiveShared: {
                    process = new CustResponsiveUpdateMsgProcess(this.getEwayWebResource(), "CreateAccessCodeShared".concat(".json"));
                    break;
                }
                case TransparentRedirect: {
                    process = new CustTransparentUpdateMsgProcess(this.getEwayWebResource(), "CreateAccessCode".concat(".json"));
                    break;
                }
                default: {
                    return this.makeResponseWithException(new ParameterInvalidException("Not support this payment type"), CreateCustomerResponse.class);
                }
            }
            return (CreateCustomerResponse)process.doWork(customer);
        }
        catch (RapidSdkException e) {
            LOGGER.error(e.getMessage());
            return this.makeResponseWithException(e, CreateCustomerResponse.class);
        }
    }

    @Override
    public QueryTransactionResponse queryTransaction(int transactionId) {
        return this.queryTransaction(String.valueOf(transactionId));
    }

    @Override
    public QueryTransactionResponse queryTransaction(String accessCode) {
        return this.queryTransactionWithPath(accessCode, "Transaction");
    }

    private QueryTransactionResponse queryTransactionWithPath(String request, String ... requestPath) {
        if (!this.isValid()) {
            return this.makeResponseWithException(new APIKeyInvalidException("API Key, Password or Rapid endpoint is invalid"), QueryTransactionResponse.class);
        }
        try {
            TransQueryMsgProcess process = new TransQueryMsgProcess(this.getEwayWebResource(), requestPath);
            return (QueryTransactionResponse)process.doWork(request);
        }
        catch (RapidSdkException e) {
            LOGGER.error(e.getMessage());
            return this.makeResponseWithException(e, QueryTransactionResponse.class);
        }
    }

    @Override
    public QueryTransactionResponse queryTransaction(TransactionFilter filter) {
        Integer indexOfValue = filter.calculateIndexOfValue();
        if (indexOfValue == null) {
            return this.makeResponseWithException(new APIKeyInvalidException("Invalid transaction filter input"), QueryTransactionResponse.class);
        }
        switch (indexOfValue) {
            case 1: {
                return this.queryTransaction(String.valueOf(filter.getTransactionId()));
            }
            case 2: {
                return this.queryTransaction(filter.getAccessCode());
            }
            case 3: {
                return this.queryTransactionWithPath(filter.getInvoiceNumber(), "Transaction", "InvoiceNumber");
            }
            case 4: {
                return this.queryTransactionWithPath(filter.getInvoiceReference(), "Transaction", "InvoiceRef");
            }
        }
        return this.makeResponseWithException(new APIKeyInvalidException("Unsupported transaction filter"), QueryTransactionResponse.class);
    }

    @Override
    public QueryCustomerResponse queryCustomer(long tokenCustomerID) {
        if (!this.isValid()) {
            return this.makeResponseWithException(new APIKeyInvalidException("API Key, Password or Rapid endpoint is invalid"), QueryCustomerResponse.class);
        }
        try {
            QueryCustomerMsgProcess process = new QueryCustomerMsgProcess(this.getEwayWebResource(), "DirectCustomerSearch".concat(".json"));
            return (QueryCustomerResponse)process.doWork(String.valueOf(tokenCustomerID));
        }
        catch (RapidSdkException e) {
            LOGGER.error(e.getMessage());
            return this.makeResponseWithException(e, QueryCustomerResponse.class);
        }
    }

    @Override
    public RefundResponse refund(Refund refund) {
        if (!this.isValid()) {
            return this.makeResponseWithException(new APIKeyInvalidException("API Key, Password or Rapid endpoint is invalid"), RefundResponse.class);
        }
        try {
            RefundMsgProcess process = null;
            process = new RefundMsgProcess(this.getEwayWebResource(), "Transaction");
            return (RefundResponse)process.doWork(refund);
        }
        catch (RapidSdkException e) {
            LOGGER.error(e.getMessage());
            return this.makeResponseWithException(e, RefundResponse.class);
        }
    }

    @Override
    public RefundResponse cancel(Refund refund) {
        if (!this.isValid()) {
            return this.makeResponseWithException(new APIKeyInvalidException("API Key, Password or Rapid endpoint is invalid"), RefundResponse.class);
        }
        try {
            CancelAuthorisationMsgProcess process = new CancelAuthorisationMsgProcess(this.getEwayWebResource(), "CancelAuthorisation");
            return (RefundResponse)process.doWork(refund);
        }
        catch (RapidSdkException e) {
            LOGGER.error(e.getMessage());
            return this.makeResponseWithException(e, RefundResponse.class);
        }
    }

    @Override
    public String getRapidEndpoint() {
        return this.rapidEndpoint;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public List<String> getErrors() {
        return this.listError != null ? this.listError : new ArrayList<String>();
    }

    private WebResource getEwayWebResource() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        Client client = Client.create((ClientConfig)clientConfig);
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.APIKey, this.password));
        if (this.debug) {
            client.addFilter((ClientFilter)new LoggingFilter(System.out));
        }
        RapidClientFilter rapidFilter = new RapidClientFilter();
        rapidFilter.setVersion(this.apiVersion);
        client.addFilter((ClientFilter)rapidFilter);
        WebResource resource = client.resource(this.webUrl);
        return resource;
    }

    private void addErrorCode(String errCode) {
        if (errCode == null) {
            return;
        }
        if (this.listError == null) {
            this.listError = new ArrayList<String>();
            this.listError.add(errCode);
        } else if (!this.listError.contains(errCode)) {
            this.listError.add(errCode);
        }
    }

    private <T extends ResponseOutput> T makeResponseWithException(RapidSdkException e, Class<T> c) {
        if (this.debug) {
            e.printStackTrace();
        }
        try {
            ResponseOutput t = (ResponseOutput)c.newInstance();
            t.getErrors().add(e.getErrorCode());
            return (T)t;
        }
        catch (InstantiationException e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        catch (IllegalAccessException e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return null;
    }
}

