/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk;

import com.eway.payment.rapid.sdk.RapidClient;
import com.eway.payment.rapid.sdk.RapidClientImpl;
import com.eway.payment.rapid.sdk.util.ResourceUtil;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RapidSDK {
    private static final Logger LOGGER = LoggerFactory.getLogger(RapidSDK.class);

    public static RapidClient newRapidClient(String APIKey, String password, String rapidEndpoint) {
        return new RapidClientImpl(APIKey, password, rapidEndpoint);
    }

    public static String userDisplayMessage(String code, String language) {
        return RapidSDK.findErrorCode(code);
    }

    private static String findErrorCode(String code) {
        try {
            Properties prop = ResourceUtil.loadProperiesOnResourceFolder("err_code_resource_en.properties");
            return prop.getProperty(code);
        }
        catch (Exception e) {
            LOGGER.error("Load resource from file:err_code_resource_en.properties error", (Throwable)e);
            return null;
        }
    }
}

