/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert;

import com.eway.payment.rapid.sdk.beans.external.Address;
import com.eway.payment.rapid.sdk.beans.external.CardDetails;
import com.eway.payment.rapid.sdk.beans.internal.Customer;
import com.eway.payment.rapid.sdk.exception.ParameterInvalidException;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerToInternalCustomerConverter
implements BeanConverter<com.eway.payment.rapid.sdk.beans.external.Customer, Customer> {
    private boolean mergeCardDetailToThis = true;

    public CustomerToInternalCustomerConverter() {
    }

    public CustomerToInternalCustomerConverter(boolean isMergeCardInfo) {
        this.mergeCardDetailToThis = isMergeCardInfo;
    }

    @Override
    public Customer doConvert(com.eway.payment.rapid.sdk.beans.external.Customer customer) throws RapidSdkException {
        Customer iCustomer = new Customer();
        if (customer != null) {
            Address cusAddress;
            iCustomer.setPhone(customer.getPhone());
            iCustomer.setReference(customer.getReference());
            iCustomer.setTokenCustomerID(customer.getTokenCustomerID());
            iCustomer.setComments(customer.getComments());
            iCustomer.setMobile(customer.getMobile());
            iCustomer.setTitle(customer.getTitle());
            iCustomer.setFax(customer.getFax());
            iCustomer.setCustomerDeviceIP(customer.getCustomerDeviceIP());
            iCustomer.setEmail(customer.getEmail());
            iCustomer.setCompanyName(customer.getCompanyName());
            iCustomer.setUrl(customer.getUrl());
            iCustomer.setFirstName(customer.getFirstName());
            iCustomer.setLastName(customer.getLastName());
            iCustomer.setJobDescription(customer.getJobDescription());
            CardDetails cardDetail = customer.getCardDetails();
            if (cardDetail == null) {
                cardDetail = new CardDetails();
            }
            iCustomer.setCardDetails(cardDetail);
            if (cardDetail != null && this.mergeCardDetailToThis) {
                iCustomer.setCardStartMonth(cardDetail.getStartMonth());
                iCustomer.setCardStartYear(cardDetail.getStartYear());
                iCustomer.setCardIssueNumber(cardDetail.getIssueNumber());
                iCustomer.setCardName(cardDetail.getName());
                iCustomer.setCardNumber(cardDetail.getNumber());
                if (!StringUtils.isBlank((CharSequence)cardDetail.getExpiryYear())) {
                    try {
                        iCustomer.setCardExpiryYear(Integer.parseInt(cardDetail.getExpiryYear()));
                    }
                    catch (RuntimeException e) {
                        throw new ParameterInvalidException("Invalid expiry year in card details");
                    }
                }
                if (!StringUtils.isBlank((CharSequence)cardDetail.getExpiryMonth())) {
                    try {
                        iCustomer.setCardExpiryMonth(Integer.parseInt(cardDetail.getExpiryMonth()));
                    }
                    catch (RuntimeException e) {
                        throw new ParameterInvalidException("Invalid expiry month in card details");
                    }
                }
            }
            if ((cusAddress = customer.getAddress()) != null) {
                iCustomer.setState(cusAddress.getState());
                iCustomer.setPostalCode(cusAddress.getPostalCode());
                iCustomer.setCountry(cusAddress.getCountry());
                iCustomer.setCity(cusAddress.getCity());
                iCustomer.setStreet1(cusAddress.getStreet1());
                iCustomer.setStreet2(cusAddress.getStreet2());
            }
        }
        return iCustomer;
    }
}

