/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert;

import com.eway.payment.rapid.sdk.beans.external.ProcessingDetails;
import com.eway.payment.rapid.sdk.beans.external.TransactionStatus;
import com.eway.payment.rapid.sdk.entities.DirectRefundResponse;
import com.eway.payment.rapid.sdk.exception.ParameterInvalidException;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectRefundToTransStatusConverter
implements BeanConverter<DirectRefundResponse, TransactionStatus> {
    @Override
    public TransactionStatus doConvert(DirectRefundResponse response) throws RapidSdkException {
        TransactionStatus status = new TransactionStatus();
        status.setProcessingDetails(this.getProcessingDetails(response));
        if (response.getTransactionStatus() != null) {
            status.setStatus(response.getTransactionStatus());
        }
        if (!StringUtils.isBlank((CharSequence)response.getTransactionID())) {
            try {
                status.setTransactionID(Integer.parseInt(response.getTransactionID()));
            }
            catch (Exception e) {
                throw new ParameterInvalidException("Invalid Transaction ID");
            }
        }
        return status;
    }

    private ProcessingDetails getProcessingDetails(DirectRefundResponse response) {
        ProcessingDetails processingDetails = new ProcessingDetails();
        processingDetails.setResponseCode(response.getResponseCode());
        processingDetails.setResponseMessage(response.getResponseMessage());
        processingDetails.setAuthorisationCode(response.getAuthorisationCode());
        return processingDetails;
    }
}

