/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert;

import com.eway.payment.rapid.sdk.beans.external.PaymentDetails;
import com.eway.payment.rapid.sdk.beans.external.ShippingDetails;
import com.eway.payment.rapid.sdk.beans.external.ShippingMethod;
import com.eway.payment.rapid.sdk.beans.external.Transaction;
import com.eway.payment.rapid.sdk.beans.internal.Customer;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import com.eway.payment.rapid.sdk.message.convert.InternalCustomerToCustomerConverter;
import com.eway.payment.rapid.sdk.message.convert.InternalTransactionToAddressConverter;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalTransToTransConverter
implements BeanConverter<com.eway.payment.rapid.sdk.beans.internal.Transaction, Transaction> {
    @Override
    public Transaction doConvert(com.eway.payment.rapid.sdk.beans.internal.Transaction iTransaction) throws RapidSdkException {
        Transaction transaction = new Transaction();
        transaction.setTokenCustomerID(iTransaction.getTokenCustomerID());
        transaction.setMaxRefund(iTransaction.getMaxRefund());
        transaction.setTransactionDateTime(iTransaction.getTransactionDateTime());
        transaction.setSource(iTransaction.getSource());
        transaction.setOriginalTransactionId(iTransaction.getOriginalTransactionId());
        com.eway.payment.rapid.sdk.beans.external.Customer eWayCustomer = this.getEwayCustomer(iTransaction);
        if (eWayCustomer.getTokenCustomerID() == null && iTransaction.getTokenCustomerID() != null) {
            eWayCustomer.setTokenCustomerID(iTransaction.getTokenCustomerID());
        }
        transaction.setCustomer(eWayCustomer);
        transaction.setPaymentDetails(this.getPaymentDetails(iTransaction));
        transaction.setShippingDetails(this.getShippingDetails(iTransaction));
        return transaction;
    }

    private com.eway.payment.rapid.sdk.beans.external.Customer getEwayCustomer(com.eway.payment.rapid.sdk.beans.internal.Transaction iTransaction) throws RapidSdkException {
        Customer iCustomer = iTransaction.getCustomer();
        InternalCustomerToCustomerConverter custConvert = new InternalCustomerToCustomerConverter();
        com.eway.payment.rapid.sdk.beans.external.Customer customer = custConvert.doConvert(iCustomer);
        InternalTransactionToAddressConverter addressConvert = new InternalTransactionToAddressConverter();
        customer.setAddress(addressConvert.doConvert(iTransaction));
        return customer;
    }

    private PaymentDetails getPaymentDetails(com.eway.payment.rapid.sdk.beans.internal.Transaction iTransaction) {
        PaymentDetails paymentDetails = new PaymentDetails();
        paymentDetails.setTotalAmount(iTransaction.getTotalAmount());
        paymentDetails.setInvoiceReference(iTransaction.getInvoiceReference());
        paymentDetails.setInvoiceNumber(iTransaction.getInvoiceNumber());
        paymentDetails.setCurrencyCode(iTransaction.getCurrencyCode());
        return paymentDetails;
    }

    private ShippingDetails getShippingDetails(com.eway.payment.rapid.sdk.beans.internal.Transaction iTransaction) throws RapidSdkException {
        ShippingDetails shippingDetails = new ShippingDetails();
        if (iTransaction.getShippingAddress() != null) {
            InternalTransactionToAddressConverter addressConvert = new InternalTransactionToAddressConverter();
            shippingDetails.setShippingAddress(addressConvert.doConvert(iTransaction));
            String methodName = iTransaction.getShippingAddress().getShippingMethod();
            if (!StringUtils.isBlank((CharSequence)methodName)) {
                for (ShippingMethod m : ShippingMethod.values()) {
                    if (!m.name().equalsIgnoreCase(methodName)) continue;
                    shippingDetails.setShippingMethod(m);
                    break;
                }
            }
        }
        if (iTransaction.getShippingAddress() != null) {
            shippingDetails.setEmail(iTransaction.getShippingAddress().getEmail());
            shippingDetails.setFax(iTransaction.getShippingAddress().getFax());
            shippingDetails.setLastName(iTransaction.getShippingAddress().getLastName());
            shippingDetails.setFirstName(iTransaction.getShippingAddress().getFirstName());
            shippingDetails.setPhone(iTransaction.getShippingAddress().getPhone());
        }
        return shippingDetails;
    }
}

