/*
 * Decompiled with CFR 0.152.
 */
package com.eway.payment.rapid.sdk.message.convert;

import com.eway.payment.rapid.sdk.beans.external.BeagleVerifyStatus;
import com.eway.payment.rapid.sdk.beans.external.FraudAction;
import com.eway.payment.rapid.sdk.beans.external.ProcessingDetails;
import com.eway.payment.rapid.sdk.beans.external.TransactionStatus;
import com.eway.payment.rapid.sdk.beans.external.VerificationResult;
import com.eway.payment.rapid.sdk.beans.internal.BeagleVerification;
import com.eway.payment.rapid.sdk.beans.internal.Transaction;
import com.eway.payment.rapid.sdk.exception.ParameterInvalidException;
import com.eway.payment.rapid.sdk.exception.RapidSdkException;
import com.eway.payment.rapid.sdk.message.convert.BeanConverter;
import com.eway.payment.rapid.sdk.message.convert.VerificationToVerifiResultConverter;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalTransactionToStatusConverter
implements BeanConverter<Transaction, TransactionStatus> {
    @Override
    public TransactionStatus doConvert(Transaction transaction) throws RapidSdkException {
        TransactionStatus transactionStatus = new TransactionStatus();
        if (transaction.getBeagleScore() != null) {
            transactionStatus.setBeagleScore(transaction.getBeagleScore());
        }
        transactionStatus.setStatus(transaction.getTransactionStatus());
        transactionStatus.setTotal(transaction.getTotalAmount());
        transactionStatus.setCaptured(transaction.getTransactionCaptured());
        transactionStatus.setProcessingDetails(this.getProcessingDetails(transaction));
        if (!StringUtils.isBlank((CharSequence)transaction.getFraudAction())) {
            try {
                transactionStatus.setFraudAction(FraudAction.valueOf(transaction.getFraudAction()));
            }
            catch (Exception e) {
                throw new ParameterInvalidException("Invalid Transaction Fraud Action: " + transaction.getFraudAction());
            }
        }
        if (!StringUtils.isBlank((CharSequence)transaction.getTransactionID())) {
            try {
                transactionStatus.setTransactionID(Integer.parseInt(transaction.getTransactionID()));
            }
            catch (Exception e) {
                throw new ParameterInvalidException("Invalid Transaction ID");
            }
        }
        VerificationToVerifiResultConverter converter = new VerificationToVerifiResultConverter();
        VerificationResult result = (VerificationResult)converter.doConvert(transaction.getVerification());
        BeagleVerification beagleVerification = transaction.getBeagleVerification();
        if (beagleVerification != null) {
            String email = beagleVerification.getEmail();
            String phone = beagleVerification.getPhone();
            result.setBeagleEmail(this.getBeagleVerification(email));
            result.setBeaglePhone(this.getBeagleVerification(phone));
        }
        transactionStatus.setVerificationResult(result);
        return transactionStatus;
    }

    private ProcessingDetails getProcessingDetails(Transaction response) {
        ProcessingDetails processingDetails = new ProcessingDetails();
        processingDetails.setAuthorisationCode(response.getAuthorisationCode());
        processingDetails.setResponseCode(response.getResponseCode());
        processingDetails.setResponseMessage(response.getResponseMessage());
        return processingDetails;
    }

    private BeagleVerifyStatus getBeagleVerification(String code) {
        if ("0".equalsIgnoreCase(code)) {
            return BeagleVerifyStatus.NotVerified;
        }
        if ("1".equalsIgnoreCase(code)) {
            return BeagleVerifyStatus.Attempted;
        }
        if ("2".equalsIgnoreCase(code)) {
            return BeagleVerifyStatus.Verified;
        }
        if ("3".equalsIgnoreCase(code)) {
            return BeagleVerifyStatus.Failed;
        }
        return null;
    }
}

